/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types;

import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.ADesertDungeonPiece;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonDeco;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.util.PieceConnection;
import com.becks.uniquedungeons.util.DirectionHelper;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;

public abstract class ADesertDungeonMidPiece
extends ADesertDungeonPiece {
    private final int downwardsAngle = ADesertDungeonMidPiece.generateDownwardsAngle(this);
    private final Rotation angle = ADesertDungeonMidPiece.generateAngle(this);

    protected ADesertDungeonMidPiece(PieceConnection entrance, PieceConnection[] exits, String name, Tuple<DesertDungeonDeco, Tuple<Vec3i, Rotation>>[] deco) {
        super(entrance, exits, name, deco);
    }

    private static int generateDownwardsAngle(ADesertDungeonPiece piece) {
        int enHeight = piece.getEntrance().getVertikalOffset();
        int exHeight = 0;
        for (PieceConnection c : piece.getExits()) {
            if (c.getVertikalOffset() <= exHeight) continue;
            exHeight = c.getVertikalOffset();
        }
        return enHeight - exHeight;
    }

    private static Rotation generateAngle(ADesertDungeonPiece piece) {
        if (piece.getExits().length > 1) {
            return null;
        }
        return DirectionHelper.getRotationNoOpp(piece.getEntrance().getDirection().m_122424_(), piece.getExits()[0].getDirection());
    }

    public int getDownwardsAngle() {
        return this.downwardsAngle;
    }

    public Rotation getAngle() {
        return this.angle;
    }
}

