/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.registries;

import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonDeco;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.types.DesertDungeonRoom;
import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.util.PieceConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;

public class DesertDungeonRoomRegistry {
    private static final List<DesertDungeonRoom> rooms = new ArrayList<DesertDungeonRoom>();
    private static DesertDungeonRoomRegistry INSTANCE;

    private DesertDungeonRoomRegistry() {
    }

    public static DesertDungeonRoomRegistry get() {
        if (INSTANCE == null) {
            INSTANCE = new DesertDungeonRoomRegistry();
        }
        return INSTANCE;
    }

    public static DesertDungeonRoom register(String name, PieceConnection entrance, PieceConnection[] exits, Tuple<DesertDungeonDeco, Tuple<Vec3i, Rotation>>[] deco) {
        DesertDungeonRoom room = new DesertDungeonRoom(entrance, exits, name, deco);
        rooms.add(room);
        return room;
    }

    public static DesertDungeonRoom getRandom() {
        Random rand = new Random();
        return rooms.get(rand.nextInt(rooms.size()));
    }

    public static DesertDungeonRoom getRandom(List<DesertDungeonRoom> used) {
        ArrayList<DesertDungeonRoom> useable = new ArrayList<DesertDungeonRoom>();
        for (DesertDungeonRoom r : rooms) {
            if (used.contains(r)) continue;
            useable.add(r);
        }
        if (useable.size() < 1) {
            return DesertDungeonRoomRegistry.getRandom();
        }
        Random rand = new Random();
        return (DesertDungeonRoom)useable.get(rand.nextInt(useable.size()));
    }
}

