/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.structures.desert_dungeon;

import com.becks.uniquedungeons.common.structures.desert_dungeon.pieces.DesertDungeonPieces;
import com.becks.uniquedungeons.core.init.structureInit.StructureInit;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class DesertDungeon
extends Structure {
    public static final Codec<DesertDungeon> CODEC = DesertDungeon.m_226607_(DesertDungeon::new);

    public DesertDungeon(Structure.StructureSettings p_227526_) {
        super(p_227526_);
    }

    public DesertDungeon() {
        super(new Structure.StructureSettings((HolderSet)BuiltinRegistries.f_123865_.m_203561_(BiomeTags.f_215817_), new HashMap(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        ChunkPos chunkpos = context.f_226628_();
        BlockPos genpos = chunkpos.m_45615_();
        Random rand = new Random();
        genpos.m_7918_(rand.nextInt(16), 0, rand.nextInt(16));
        Direction xVec = rotation.m_55954_(Direction.SOUTH);
        Direction zVec = rotation.m_55954_(Direction.EAST);
        BlockPos cornerPos1 = genpos.m_121955_(xVec.m_122436_().m_142393_(25));
        BlockPos cornerPos2 = genpos.m_121955_(zVec.m_122436_().m_142393_(25));
        BlockPos cornerPos3 = genpos.m_121955_(xVec.m_122436_().m_142393_(25)).m_121955_(zVec.m_122436_().m_142393_(25));
        BlockPos centerPos = genpos.m_121955_(xVec.m_122436_().m_142393_(13)).m_121955_(zVec.m_122436_().m_142393_(13));
        int y1 = context.f_226622_().m_223235_(genpos.m_123341_(), genpos.m_123343_(), Heightmap.Types.WORLD_SURFACE, context.f_226629_(), context.f_226624_());
        int y2 = context.f_226622_().m_223235_(cornerPos1.m_123341_(), cornerPos1.m_123343_(), Heightmap.Types.WORLD_SURFACE, context.f_226629_(), context.f_226624_());
        int y3 = context.f_226622_().m_223235_(cornerPos2.m_123341_(), cornerPos2.m_123343_(), Heightmap.Types.WORLD_SURFACE, context.f_226629_(), context.f_226624_());
        int y4 = context.f_226622_().m_223235_(cornerPos3.m_123341_(), cornerPos3.m_123343_(), Heightmap.Types.WORLD_SURFACE, context.f_226629_(), context.f_226624_());
        int y5 = context.f_226622_().m_223235_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.WORLD_SURFACE, context.f_226629_(), context.f_226624_());
        int miny = Math.min(y1, Math.min(y2, Math.min(y3, Math.min(y4, y5))));
        if (Math.abs(Math.max(y1, Math.max(y2, Math.max(y3, Math.max(y4, y5)))) - miny) > 10) {
            return Optional.empty();
        }
        BlockPos finalGenpos = new BlockPos(genpos.m_123341_(), miny, genpos.m_123343_());
        return finalGenpos.m_123342_() < 60 ? Optional.empty() : Optional.of(new Structure.GenerationStub(finalGenpos, p_227538_ -> this.generatePieces((StructurePiecesBuilder)p_227538_, finalGenpos, rotation, context)));
    }

    private void generatePieces(StructurePiecesBuilder builder, BlockPos p_227531_, Rotation p_227532_, Structure.GenerationContext context) {
        ArrayList list = Lists.newArrayList();
        DesertDungeonPieces.startGeneration(context.f_226622_(), context.f_226629_(), context.f_226624_(), context.f_226625_(), p_227531_, p_227532_, list, (RandomSource)context.f_226626_());
        list.forEach(t -> builder.m_142679_((StructurePiece)t.m_14418_()));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureInit.DESERT_DUNGEON_1.get();
    }
}

