/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.stackCooldowns;

import com.becks.uniquedungeons.UniqueDungeons;
import com.becks.uniquedungeons.common.stackCooldowns.StackWrapper;
import com.becks.uniquedungeons.network.proxy.ServerProxy;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StackCooldowns {
    private final Map<StackWrapper, CooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public boolean isOnCooldown(ItemStack stack) {
        return this.getCooldownPercent(stack, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(ItemStack stack, float pPartialTicks) {
        CooldownInstance itemcooldowns$cooldowninstance = this.search(stack);
        if (itemcooldowns$cooldowninstance != null) {
            float f = itemcooldowns$cooldowninstance.endTime - itemcooldowns$cooldowninstance.startTime;
            float f1 = (float)itemcooldowns$cooldowninstance.endTime - ((float)this.tickCount + pPartialTicks);
            return Mth.m_14036_((float)(f1 / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if ((UniqueDungeons.proxy instanceof ServerProxy || UniqueDungeons.proxy.getMinecraft().m_18695_()) && !this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<StackWrapper, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<StackWrapper, CooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey().resolve(), false);
            }
        }
    }

    public void addCooldown(ItemStack stack, int pTicks, boolean syncadd) {
        this.searchAndRemove(stack);
        this.cooldowns.put(new StackWrapper(stack), new CooldownInstance(this.tickCount, this.tickCount + pTicks));
        this.onCooldownStarted(stack, pTicks, syncadd);
    }

    public void addCooldown(Player p, int pTicks, EquipmentSlot slot, boolean syncadd) {
        this.addCooldown(p.m_6844_(slot), pTicks, syncadd);
    }

    public void removeCooldown(ItemStack stack, boolean syncremove) {
        this.searchAndRemove(stack);
        this.onCooldownEnded(stack, syncremove);
    }

    protected void onCooldownStarted(ItemStack stack, int pTicks, boolean syncadd) {
    }

    protected void onCooldownEnded(ItemStack stack, boolean syncremove) {
    }

    private boolean searchAndRemove(ItemStack stack) {
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<StackWrapper, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            StackWrapper wrappedStack = new StackWrapper(stack);
            while (iterator.hasNext()) {
                Map.Entry<StackWrapper, CooldownInstance> entry = iterator.next();
                if (!entry.getKey().equals(wrappedStack)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private CooldownInstance search(ItemStack stack) {
        if (!this.cooldowns.isEmpty()) {
            StackWrapper wrappedStack = new StackWrapper(stack);
            for (Map.Entry<StackWrapper, CooldownInstance> entry : this.cooldowns.entrySet()) {
                if (!entry.getKey().equals(wrappedStack)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    static class CooldownInstance {
        final int startTime;
        final int endTime;

        CooldownInstance(int pStartTime, int pEndTime) {
            this.startTime = pStartTime;
            this.endTime = pEndTime;
        }
    }
}

