/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.items.artifacts;

import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItemSword;
import com.becks.uniquedungeons.common.stackCooldowns.StackCooldownItem;
import com.becks.uniquedungeons.common.stackCooldowns.StackCooldownMap;
import com.becks.uniquedungeons.common.stackCooldowns.StackCooldowns;
import com.becks.uniquedungeons.common.stackCooldowns.StackWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class RageBlade
extends ArtifactItemSword
implements StackCooldownItem {
    private static final String STACK_KEY = "uniquedungeons.stacks";

    public RageBlade(Item.Properties pProperties) {
        super((Tier)Tiers.DIAMOND, 1, -3.5f, pProperties);
    }

    @Override
    public Collection<Component> generateInfoLoreText(ItemStack stack, Level level) {
        ArrayList<Component> components = new ArrayList<Component>();
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound == null || !nbtTagCompound.m_128441_(STACK_KEY)) {
            this.removeStacks(stack);
        }
        assert (nbtTagCompound != null);
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.rage_blade.stacks").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("" + nbtTagCompound.m_128451_(STACK_KEY))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.rage_blade.damage_modifier").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("" + this.getStackDamageModifier(stack))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.rage_blade.speed_modifier").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)("" + this.getStackSpeedModifier(stack))).m_130940_(ChatFormatting.GOLD)));
        if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.shift_for_more").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.rage_blade.lore").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.repair").m_130940_(ChatFormatting.WHITE).m_7220_(this.getRepairItem().m_7626_(this.getRepairItem().m_7968_())));
        }
        return components;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42792_;
    }

    private double getStackSpeedModifier(ItemStack stack) {
        double scale = Math.pow(10.0, 3.0);
        double value = Math.sqrt(0.5 * (double)stack.m_41783_().m_128451_(STACK_KEY));
        return (double)Math.round(value * scale) / scale;
    }

    private double getStackDamageModifier(ItemStack stack) {
        double scale = Math.pow(10.0, 3.0);
        double value = 1.0 + Math.sqrt(stack.m_41783_().m_128451_(STACK_KEY)) / 10.0;
        return (double)Math.round(value * scale) / scale;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap defaultMap = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            defaultMap.forEach((a, am) -> this.putHelperMethod((Attribute)a, (AttributeModifier)am, (ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, stack));
            return builder.build();
        }
        return defaultMap;
    }

    private void putHelperMethod(Attribute a, AttributeModifier am, ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, ItemStack stack) {
        if (a.equals(Attributes.f_22283_)) {
            assert (stack.m_41783_() != null);
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", am.m_22218_() + this.getStackSpeedModifier(stack), AttributeModifier.Operation.ADDITION));
        } else if (a.equals(Attributes.f_22281_)) {
            assert (stack.m_41783_() != null);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", am.m_22218_() * this.getStackDamageModifier(stack), AttributeModifier.Operation.ADDITION));
        } else {
            builder.put((Object)a, (Object)am);
        }
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        StackCooldowns cooldowns;
        boolean hurtSuper = super.m_7579_(pStack, pTarget, pAttacker);
        if (hurtSuper && !pTarget.m_9236_().f_46443_ && (cooldowns = StackCooldownMap.getCooldowns((Player)pAttacker)) != null) {
            cooldowns.addCooldown(pStack, 100, false);
            this.addStack(pStack);
        }
        return hurtSuper;
    }

    @Override
    public String getCooldownID(ItemStack stack) {
        String id = "";
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_("uniquedungeons.stackCooldownID")) {
            id = nbtTagCompound.m_128461_("uniquedungeons.stackCooldownID");
            return id;
        }
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundTag();
        }
        id = UUID.randomUUID().toString();
        nbtTagCompound.m_128359_("uniquedungeons.stackCooldownID", id);
        stack.m_41751_(nbtTagCompound);
        return id;
    }

    public void addStack(ItemStack stack) {
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_(STACK_KEY)) {
            int stacks = nbtTagCompound.m_128451_(STACK_KEY);
            nbtTagCompound.m_128473_(STACK_KEY);
            nbtTagCompound.m_128405_(STACK_KEY, ++stacks);
            stack.m_41751_(nbtTagCompound);
            return;
        }
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundTag();
        }
        nbtTagCompound.m_128405_(STACK_KEY, 1);
        stack.m_41751_(nbtTagCompound);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.removeStacks(item);
        return super.onDroppedByPlayer(item, player);
    }

    public void removeStacks(ItemStack stack) {
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_(STACK_KEY)) {
            nbtTagCompound.m_128473_(STACK_KEY);
            nbtTagCompound.m_128405_(STACK_KEY, 0);
            stack.m_41751_(nbtTagCompound);
            return;
        }
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundTag();
        }
        nbtTagCompound.m_128405_(STACK_KEY, 0);
        stack.m_41751_(nbtTagCompound);
    }

    @Override
    public void onCooldownEnd(Player player, ItemStack stack) {
        for (ItemStack s : player.m_150109_().f_35974_) {
            if (!(s.m_41720_() instanceof StackCooldownItem) || !new StackWrapper(stack).equals(new StackWrapper(s))) continue;
            this.removeStacks(s);
        }
    }
}

