/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.items.artifacts;

import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItemSword;
import com.becks.uniquedungeons.core.init.itemInit.ArtifactInit;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class BloodSword
extends ArtifactItemSword {
    public BloodSword(Item.Properties pProperties) {
        super((Tier)Tiers.DIAMOND, 1, 1.0f, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        boolean hurtSuper = super.m_7579_(pStack, pTarget, pAttacker);
        if (hurtSuper && pTarget instanceof TamableAnimal && ((TamableAnimal)pTarget).m_21826_().m_7306_((Entity)pAttacker)) {
            this.addBlood(pStack, (int)((AttributeModifier)this.getAttributeModifiers(EquipmentSlot.MAINHAND, pStack).get((Object)Attributes.f_22281_).iterator().next()).m_22218_());
        }
        return hurtSuper;
    }

    public void addBlood(ItemStack stack, int amount) {
        if (!stack.m_150930_((Item)ArtifactInit.BLOOD_SWORD.get())) {
            return;
        }
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound != null && nbtTagCompound.m_128441_("uniquedungeons.blood")) {
            int blood = nbtTagCompound.m_128451_("uniquedungeons.blood");
            nbtTagCompound.m_128473_("uniquedungeons.blood");
            nbtTagCompound.m_128405_("uniquedungeons.blood", blood += amount);
            stack.m_41751_(nbtTagCompound);
            return;
        }
        if (nbtTagCompound == null) {
            nbtTagCompound = new CompoundTag();
        }
        nbtTagCompound.m_128405_("uniquedungeons.blood", 0);
        stack.m_41751_(nbtTagCompound);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap defaultMap = super.m_7167_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            defaultMap.forEach((a, am) -> this.putHelperMethod((Attribute)a, (AttributeModifier)am, (ImmutableMultimap.Builder<Attribute, AttributeModifier>)builder, stack));
            return builder.build();
        }
        return defaultMap;
    }

    private void putHelperMethod(Attribute a, AttributeModifier am, ImmutableMultimap.Builder<Attribute, AttributeModifier> builder, ItemStack stack) {
        if (a.equals(Attributes.f_22281_)) {
            assert (stack.m_41783_() != null);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", am.m_22218_() * this.getBloodModifier(stack), AttributeModifier.Operation.ADDITION));
        } else {
            builder.put((Object)a, (Object)am);
        }
    }

    private double getBloodModifier(ItemStack stack) {
        double scale = Math.pow(10.0, 3.0);
        double value = 1.0 + Math.sqrt(stack.m_41783_().m_128451_("uniquedungeons.blood")) / 10.0;
        return (double)Math.round(value * scale) / scale;
    }

    @Override
    public Collection<Component> generateInfoLoreText(ItemStack stack, Level level) {
        ArrayList<Component> components = new ArrayList<Component>();
        CompoundTag nbtTagCompound = stack.m_41783_();
        if (nbtTagCompound == null || !nbtTagCompound.m_128441_("uniquedungeons.blood")) {
            this.addBlood(stack, 0);
        }
        assert (nbtTagCompound != null);
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.blood_sword.blood").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)("" + nbtTagCompound.m_128451_("uniquedungeons.blood"))).m_130940_(ChatFormatting.DARK_RED)));
        components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.blood_sword.damage_modifier").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)("" + this.getBloodModifier(stack))).m_130940_(ChatFormatting.DARK_RED)));
        if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.shift_for_more").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.blood_sword.lore").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"lore.item.uniquedungeons.repair").m_130940_(ChatFormatting.WHITE).m_7220_(this.getRepairItem().m_7626_(this.getRepairItem().m_7968_())));
        }
        return components;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_220224_;
    }
}

