/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.blocks.cracked_blocks;

import com.becks.uniquedungeons.common.blocks.cracked_blocks.CrackingPattern;
import com.becks.uniquedungeons.core.init.BlockInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CrackedStone
extends Block {
    private Random randomGenerator = new Random();
    private SoundEvent crackSound;

    public CrackedStone(BlockBehaviour.Properties properties, SoundEvent crackSound) {
        super(properties);
        this.crackSound = crackSound;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float f) {
        super.m_142072_(world, state, pos, entity, f);
        if (!(entity instanceof Bat)) {
            this.breaking(world, pos, 1.0, new CrackingPattern(), null);
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        super.m_141947_(world, pos, state, entity);
        if (!entity.m_6047_() && !(entity instanceof Bat)) {
            this.breaking(world, pos, 0.05, new CrackingPattern(), null);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block pos2, BlockPos pos3, boolean b) {
        super.m_6861_(state, level, pos, pos2, pos3, b);
        Boolean breaking = true;
        for (Direction d : Direction.values()) {
            breaking = breaking != false && level.m_8055_(pos.m_121945_(d)).m_60795_();
        }
        if (breaking.booleanValue()) {
            this.breaking(level, pos, 1.0, new CrackingPattern(), null);
        }
    }

    private void breaking(Level level, BlockPos pos, double chance, CrackingPattern pattern, Direction crackDirection) {
        this.breaking(level, pos, chance, pattern, crackDirection, this.randomGenerator.nextDouble());
    }

    private void breaking(Level level, BlockPos pos, double chance, CrackingPattern pattern, Direction crackDirection, double randomDouble) {
        if (level.f_46443_) {
            return;
        }
        if (!(randomDouble < chance)) {
            return;
        }
        if (!level.m_8055_(pos).m_60734_().equals(BlockInit.CRACKED_DARK_ANTIQUE_STONE.get())) {
            return;
        }
        BlockPos posLower = new BlockPos(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
        if (!level.m_8055_(posLower).m_60795_()) {
            return;
        }
        level.m_46597_(pos, ((Block)BlockInit.DARK_ANTIQUE_GRAVEL.get()).m_49966_());
        level.m_5594_(null, pos, this.crackSound, SoundSource.BLOCKS, 10.0f, 1.0f);
        for (Direction d : Direction.values()) {
            int test = pattern.test(d);
            if (test <= 0) continue;
            if (test == 1) {
                this.breaking(level, pos.m_121945_(d), this.crackChance(crackDirection, d), pattern.copy().add(d), d);
                continue;
            }
            if (test != 2) continue;
            this.breaking(level, pos.m_121945_(d), this.crackChance(crackDirection, d), pattern, d);
        }
    }

    private double crackChance(Direction d1, Direction d2) {
        return d1 == null || d2 == null ? 0.9 : (d1.equals((Object)d2) ? 0.5 : 0.25);
    }
}

