/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock;

import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock.ItemBox;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock.ItemBoxBlock;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock.ItemBoxBlockEntity;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.MultiHighlightBlock;
import com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.SelectionBox;
import com.becks.uniquedungeons.util.DirectionHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ItemBoxBlockRenderer
implements BlockEntityRenderer<ItemBoxBlockEntity> {
    private final Minecraft mc = Minecraft.m_91087_();

    public void render(ItemBoxBlockEntity blockEntity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemBoxBlock block = (ItemBoxBlock)blockEntity.m_58900_().m_60734_();
        BlockState state = blockEntity.m_58900_();
        Rotation relativeRotation = DirectionHelper.getRotation((Direction)state.m_61143_((Property)MultiHighlightBlock.FACING), Direction.SOUTH);
        Vector3d blockMiddleOffset = new Vector3d(-8.0, -8.0, -8.0);
        for (SelectionBox b : block.getItemBoxes()) {
            if (blockEntity.getItemType(((ItemBox)b).getSlot()).equals(Items.f_41852_)) continue;
            int lightLevel = this.getLightLevel(blockEntity.m_58904_(), blockEntity.m_58899_().m_7494_());
            ItemStack stack = blockEntity.m_8020_(((ItemBox)b).getSlot());
            Vector3d translation = new Vector3d(((ItemBox)b).getRenderTranslation(stack)[0], ((ItemBox)b).getRenderTranslation(stack)[1], ((ItemBox)b).getRenderTranslation(stack)[2]);
            translation.m_176283_(16.0);
            translation.m_176291_(blockMiddleOffset);
            translation = DirectionHelper.getRotatedVec(translation, relativeRotation);
            blockMiddleOffset.m_176283_(-1.0);
            translation.m_176291_(blockMiddleOffset);
            translation.m_176283_(0.0625);
            Quaternion relativeQuat = ((ItemBox)b).getRenderRotation();
            relativeQuat.m_80148_(Vector3f.f_122227_.m_122240_((float)DirectionHelper.getRotationDegrees(relativeRotation)));
            this.renderItem(stack, new double[]{translation.f_86214_, translation.f_86215_, translation.f_86216_}, relativeQuat, matrixStackIn, bufferIn, partialTicks, combinedOverlayIn, lightLevel, ((ItemBox)b).getRenderScale());
        }
    }

    protected void renderItem(ItemStack stack, double[] translation, Quaternion rotation, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, int combinedOverlay, int lightLevel, float scale) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85841_(scale, scale, scale);
        BakedModel model = this.mc.m_91291_().m_174264_(stack, null, null, 1);
        this.mc.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, model);
        matrixStack.m_85849_();
    }

    protected int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.m_45517_(LightLayer.BLOCK, pos);
        int sLight = world.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }
}

