/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.blocks.abstracts.MultiHighlightBlock.ItemBoxBlock;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ItemBoxBlockEntity<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>>
extends BlockEntity
implements Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";
    @Nullable
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    protected C inventory;

    public static InventoryFactory<ItemStackHandler> defaultInventory(int slots) {
        return self -> new ItemStackHandler(slots);
    }

    public ItemBoxBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState state, InventoryFactory<C> inventoryFactory) {
        super(p_155228_, p_155229_, state);
        this.inventory = inventoryFactory.create(this);
    }

    public Item getItemType(int slot) {
        if (slot > this.inventory.getSlots()) {
            return null;
        }
        return this.inventory.getStackInSlot(slot).m_41720_();
    }

    public ItemStack m_8020_(int slot) {
        if (slot > this.inventory.getSlots()) {
            return null;
        }
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot) {
        this.m_6596_();
        if (slot > this.inventory.getSlots()) {
            return null;
        }
        return this.inventory.extractItem(slot, 1, false);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.m_6596_();
        if (slot <= this.inventory.getSlots() && this.inventory.getStackInSlot(slot).m_41720_().equals(Items.f_41852_)) {
            stack.m_41764_(1);
            this.inventory.insertItem(slot, stack, false);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", ((INBTSerializable)this.inventory).serializeNBT());
        this.trySaveLootTable(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ((INBTSerializable)this.inventory).deserializeNBT((Tag)tag.m_128469_("inventory"));
        this.tryLoadLootTable(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet.m_131708_() != null) {
            this.handleUpdateTag(packet.m_131708_());
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", ((INBTSerializable)this.inventory).serializeNBT());
        this.trySaveLootTable(tag);
        return tag;
    }

    protected boolean tryLoadLootTable(CompoundTag pTag) {
        if (pTag.m_128425_(LOOT_TABLE_TAG, 8)) {
            this.lootTable = new ResourceLocation(pTag.m_128461_(LOOT_TABLE_TAG));
            this.lootTableSeed = pTag.m_128454_(LOOT_TABLE_SEED_TAG);
            this.unpackLootTable();
            return true;
        }
        return false;
    }

    protected boolean trySaveLootTable(CompoundTag pTag) {
        if (this.lootTable == null) {
            return false;
        }
        pTag.m_128359_(LOOT_TABLE_TAG, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            pTag.m_128356_(LOOT_TABLE_SEED_TAG, this.lootTableSeed);
        }
        return true;
    }

    public void unpackLootTable() {
        if (this.lootTable == null) {
            return;
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return;
        }
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
        if (server == null) {
            return;
        }
        LootTable loottable = server.m_129898_().m_79217_(this.lootTable);
        this.lootTable = null;
        LootContext.Builder lootcontext$builder = new LootContext.Builder(server.m_129783_()).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_(this.lootTableSeed);
        loottable.m_79123_((Container)this, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
        this.m_6596_();
    }

    public void onLoad() {
        super.onLoad();
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.removeItem(pSlot);
    }

    public ItemStack m_8016_(int pSlot) {
        return this.removeItem(pSlot);
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @FunctionalInterface
    public static interface InventoryFactory<C extends IItemHandlerModifiable & INBTSerializable<CompoundTag>> {
        public C create(ItemBoxBlockEntity<C> var1);
    }
}

