/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.artifact_unlock;

import com.becks.uniquedungeons.UniqueDungeons;
import com.becks.uniquedungeons.common.artifact_unlock.ArtifactUnlockServer;
import com.becks.uniquedungeons.common.artifact_unlock.ClientsidePLayerUnlockData;
import com.becks.uniquedungeons.common.artifact_unlock.PlayerUnlockData;
import com.becks.uniquedungeons.common.items.artifacts.abstracts.ArtifactItem;
import com.becks.uniquedungeons.network.Network;
import com.becks.uniquedungeons.network.packets.PaketSyncUnlock;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class UnlockUtils {
    private static final Map<UUID, PlayerUnlockData> serverSideUnlockData = new HashMap<UUID, PlayerUnlockData>();
    private static PlayerUnlockData clientSideUnlockData = new ClientsidePLayerUnlockData();

    @Nonnull
    public static PlayerUnlockData getUnlockData(@Nullable Player player, LogicalSide side) {
        if (side.isClient()) {
            return UnlockUtils.getClientUnlockData();
        }
        if (player instanceof ServerPlayer) {
            return UnlockUtils.getServerUnlockData((ServerPlayer)player);
        }
        return new ClientsidePLayerUnlockData();
    }

    @Nonnull
    public static PlayerUnlockData getClientUnlockData() {
        return clientSideUnlockData;
    }

    @Nonnull
    private static PlayerUnlockData getServerUnlockData(ServerPlayer player) {
        return UnlockUtils.getUnlockData(player.m_20148_());
    }

    public static void saveKnownArtifacts(Player p) {
        if (p instanceof ServerPlayer) {
            UUID pUUID = p.m_20148_();
            if (serverSideUnlockData.get(pUUID) != null) {
                PlayerUnlockData pData = serverSideUnlockData.get(pUUID);
                CompoundTag nbt = new CompoundTag();
                pData.saveToNBT(nbt);
                PaketSyncUnlock pkt = new PaketSyncUnlock(nbt);
                Network.sendToPlayer(pkt, (ServerPlayer)p);
            }
            UnlockUtils.savePlayerKnowledge(pUUID, true);
        }
    }

    @Nonnull
    private static PlayerUnlockData getUnlockData(UUID uuid) {
        PlayerUnlockData progress = serverSideUnlockData.get(uuid);
        if (progress == null) {
            UnlockUtils.loadPlayerKnowledge(uuid);
            progress = serverSideUnlockData.get(uuid);
        }
        return progress;
    }

    public static void unlockArtifact(Player player, ArtifactItem artifact) {
        UnlockUtils.getUnlockData(player, player instanceof ServerPlayer ? LogicalSide.SERVER : LogicalSide.CLIENT).unlock(artifact);
        UnlockUtils.saveKnownArtifacts(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateClientResearch(@Nullable PaketSyncUnlock pkt) {
        clientSideUnlockData = new PlayerUnlockData();
        if (pkt != null) {
            clientSideUnlockData.sync(pkt);
        }
    }

    public static void loadPlayerKnowledge(ServerPlayer p) {
        PaketSyncUnlock pkt = new PaketSyncUnlock(UnlockUtils.loadPlayerKnowledge(p.m_20148_()));
        Network.sendToPlayer(pkt, p);
    }

    private static CompoundTag loadPlayerKnowledge(UUID pUUID) {
        File playerFile = UnlockUtils.getPlayerFile(pUUID);
        CompoundTag nbt = null;
        try {
            nbt = NbtIo.m_128953_((File)playerFile);
            PlayerUnlockData progress = new PlayerUnlockData();
            if (nbt != null && !nbt.m_128456_()) {
                progress.loadFromNBT(nbt);
            }
            serverSideUnlockData.put(pUUID, progress);
            return nbt;
        }
        catch (Exception e) {
            return new CompoundTag();
        }
    }

    private static void savePlayerKnowledge(UUID pUUID, boolean force) {
        if (serverSideUnlockData.get(pUUID) == null) {
            return;
        }
        PlayerUnlockData pData = serverSideUnlockData.get(pUUID);
        if (force) {
            ArtifactUnlockServer.saveNow(pUUID, pData);
        }
    }

    public static File getPlayerFile(UUID pUUID) {
        File f = new File(UnlockUtils.getPlayerDirectory(), pUUID.toString() + ".uniquedungeons");
        if (!f.exists()) {
            try {
                NbtIo.m_128955_((CompoundTag)new CompoundTag(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    private static File getPlayerDirectory() {
        File pDir = new File(UniqueDungeons.proxy.getServerDataDirectory(), "playerdata");
        if (!pDir.exists()) {
            pDir.mkdirs();
        }
        return pDir;
    }
}

