/*
 * Decompiled with CFR 0.152.
 */
package com.becks.uniquedungeons.common.artifact_unlock;

import com.becks.uniquedungeons.common.artifact_unlock.PlayerUnlockData;
import com.becks.uniquedungeons.common.artifact_unlock.UnlockUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class ArtifactUnlockServer {
    private static final ArtifactUnlockServer instance = new ArtifactUnlockServer();
    private static Timer timer;
    private static TimerTask saveTask;
    private final Map<UUID, PlayerUnlockData> playerSaveQueue = new HashMap<UUID, PlayerUnlockData>();
    private final Map<UUID, PlayerUnlockData> awaitingSaveQueue = new HashMap<UUID, PlayerUnlockData>();
    private boolean inSave = false;
    private boolean skipTick = false;

    private ArtifactUnlockServer() {
    }

    public static ArtifactUnlockServer getInstance() {
        return instance;
    }

    public void onServerStart() {
        this.reset();
        saveTask = new TimerTask(){

            @Override
            public void run() {
                instance.doSave();
            }
        };
        timer = new Timer("ResearchIOThread", true);
        timer.scheduleAtFixedRate(saveTask, 30000L, 30000L);
    }

    public void onServerStop() {
        this.flushAndSaveAll();
        this.reset();
    }

    public static ArtifactUnlockServer stop(Runnable onStop) {
        return ArtifactUnlockServer.wrap(null, onStop);
    }

    public static ArtifactUnlockServer start(Runnable onStart) {
        return ArtifactUnlockServer.wrap(onStart, null);
    }

    public static ArtifactUnlockServer wrap(final @Nullable Runnable onStart, final @Nullable Runnable onStop) {
        return new ArtifactUnlockServer(){

            @Override
            public void onServerStart() {
                if (onStart != null) {
                    onStart.run();
                }
            }

            @Override
            public void onServerStop() {
                if (onStop != null) {
                    onStop.run();
                }
            }
        };
    }

    private void reset() {
        if (saveTask != null) {
            saveTask.cancel();
            saveTask = null;
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    public void doSave() {
        if (this.skipTick) {
            return;
        }
        this.inSave = true;
        for (Map.Entry<UUID, PlayerUnlockData> entry : this.playerSaveQueue.entrySet()) {
            ArtifactUnlockServer.saveNow(entry.getKey(), entry.getValue());
        }
        this.playerSaveQueue.clear();
        this.inSave = false;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        this.awaitingSaveQueue.clear();
    }

    private void scheduleSave(UUID playerUUID, PlayerUnlockData copiedProgress) {
        if (this.inSave) {
            this.awaitingSaveQueue.put(playerUUID, copiedProgress);
        } else {
            this.playerSaveQueue.put(playerUUID, copiedProgress);
        }
    }

    private void cancelScheduledSave(UUID playerUUID) {
        this.awaitingSaveQueue.remove(playerUUID);
        this.playerSaveQueue.remove(playerUUID);
    }

    private void flushAndSaveAll() {
        this.skipTick = true;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        for (Map.Entry<UUID, PlayerUnlockData> entry : this.playerSaveQueue.entrySet()) {
            ArtifactUnlockServer.saveNow(entry.getKey(), entry.getValue());
        }
        this.playerSaveQueue.clear();
        this.awaitingSaveQueue.clear();
        this.skipTick = false;
        this.inSave = false;
    }

    public static void saveProgress(UUID playerUUID, PlayerUnlockData copiedProgress) {
        if (instance != null) {
            instance.scheduleSave(playerUUID, copiedProgress);
        }
    }

    public static void cancelSave(UUID playerUUID) {
        if (instance != null) {
            instance.cancelScheduledSave(playerUUID);
        }
    }

    static void saveNow(UUID playerUUID, PlayerUnlockData progress) {
        File playerFile = UnlockUtils.getPlayerFile(playerUUID);
        try {
            CompoundTag nbt = new CompoundTag();
            progress.saveToNBT(nbt);
            NbtIo.m_128955_((CompoundTag)nbt, (File)playerFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

