/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.screen.DataHandlerScreen;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DataParamsList
extends ContainerObjectSelectionList<Entry> {
    private static final Map<Class<?>, WidgetFactory> WIDGET_FACTORIES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(Boolean.class, WidgetFactory::booleanButton);
        map.put(Direction.class, WidgetFactory::directionButton);
        map.put(Direction.Axis.class, WidgetFactory::axisButton);
        map.put(BlockState.class, (mc, parser) -> WidgetFactory.forgeRegistryEditBox(mc, parser, ForgeRegistries.BLOCKS));
        map.put(ItemStack.class, (mc, parser) -> WidgetFactory.forgeRegistryEditBox(mc, parser, ForgeRegistries.ITEMS));
        map.put(ResourceKey.class, WidgetFactory::vanillaRegistryEditBox);
    });
    public final DataHandlerScreen parentScreen;
    @Nullable
    private Entry hoveredEntry = null;
    private boolean isValid = false;

    public DataParamsList(DataHandlerScreen screen, Minecraft mc, @Nullable DataParser dataParser) {
        super(mc, screen.f_96543_ + 55, screen.f_96544_, 52, screen.f_96544_ - 36, 25);
        this.parentScreen = screen;
        this.m_93488_(false);
        this.createEntries(dataParser);
    }

    public Map<String, String> values() {
        HashMap<String, String> entries = new HashMap<String, String>();
        for (Entry entry : this.m_6702_()) {
            DataParser.Parser<?> parser;
            Object parsedVal;
            String value = entry.getValue();
            if (value.isBlank() || (parsedVal = (parser = entry.parser).parse(value)) == null) continue;
            entries.put(parser.key, value);
        }
        return entries;
    }

    public List<Entry> childrenClone() {
        return new ArrayList<Entry>(this.m_6702_());
    }

    public void createEntries(@Nullable DataParser dataParser) {
        this.m_93516_();
        if (dataParser != null) {
            List<DataParser.Parser<?>> parsers = dataParser.getParsers();
            for (int i = 0; i < parsers.size(); ++i) {
                DataParser.Parser<?> parser = parsers.get(i);
                this.m_7085_((AbstractSelectionList.Entry)new Entry(WIDGET_FACTORIES.getOrDefault(parser.type, WidgetFactory::suggestionEditBox).create(this.f_93386_, parser), parser));
            }
        }
    }

    public void setEntries(@Nullable List<Entry> entries) {
        this.m_93516_();
        if (entries != null) {
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        for (Entry e : this.m_6702_()) {
            if (!e.widget.m_93696_()) continue;
            e.widget.m_5755_(false);
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        for (Entry e : this.m_6702_()) {
            SuggestionEditBox suggestionEditBox;
            AbstractWidget abstractWidget = e.widget;
            if (!(abstractWidget instanceof SuggestionEditBox) || !(suggestionEditBox = (SuggestionEditBox)abstractWidget).m_93696_() || !suggestionEditBox.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void tick() {
        boolean isValid = true;
        for (Entry entry : this.m_6702_()) {
            if (entry.tick()) continue;
            isValid = false;
        }
        this.isValid = isValid;
        this.parentScreen.doneButton.f_93623_ = this.parentScreen.allowDoneButton();
        this.parentScreen.generateButton.f_93623_ = this.parentScreen.allowGenerateButton();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        for (Entry entry : this.m_6702_()) {
            if (!entry.widget.m_93696_()) continue;
            entry.widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.hoveredEntry != null) {
            this.parentScreen.m_169388_(poseStack, this.hoveredEntry.tooltips, Optional.empty(), mouseX, mouseY + 10);
            this.hoveredEntry = null;
        }
    }

    public class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public final AbstractWidget widget;
        public final DataParser.Parser<?> parser;
        public final Component renderLabel;
        public final List<Component> tooltips = new ArrayList<Component>();
        protected boolean isValid = true;

        public Entry(AbstractWidget widget, DataParser.Parser<?> parser) {
            this.widget = widget;
            this.parser = parser;
            String raw = parser.key;
            String labelStranslationKey = parser.getTranlsationKey("label");
            MutableComponent translatedLabel = Component.m_237115_((String)labelStranslationKey);
            if (translatedLabel.getString().equals(labelStranslationKey)) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < raw.length(); ++i) {
                    int prev = i - 1;
                    char c = raw.charAt(i);
                    if (i == 0 || prev > -1 && !Character.isAlphabetic(raw.charAt(prev))) {
                        builder.append(Character.toUpperCase(c));
                        continue;
                    }
                    builder.append(c == '_' ? (char)' ' : (char)c);
                }
                this.renderLabel = Component.m_237113_((String)builder.toString());
            } else {
                this.renderLabel = translatedLabel;
            }
            this.tooltips.add((Component)Component.m_237113_((String)this.renderLabel.getString()).m_7220_((Component)Component.m_237113_((String)(" (" + raw + ")"))).m_130940_(ChatFormatting.DARK_GREEN));
            this.createTranslatedTooltip("description", ChatFormatting.GREEN);
            if (parser.getExample() != null) {
                this.createRawTooltip("example", parser.getExample(), ChatFormatting.GREEN);
            }
            if (parser instanceof DataParser.NumberParser) {
                DataParser.NumberParser numberParser = (DataParser.NumberParser)parser;
                this.createRawTooltip("range", numberParser.getMin() + " - " + numberParser.getMax(), ChatFormatting.GREEN);
            }
            this.createRawTooltip("default", parser.getDefaultValName(), ChatFormatting.AQUA);
            this.createRawTooltip("type", parser.typeName, ChatFormatting.BLUE);
        }

        @Nullable
        private void createRawTooltip(String key, String value, ChatFormatting color) {
            this.tooltips.add((Component)Component.m_237115_((String)("gui.structure_gel.data_handler." + key)).m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(color).m_7220_((Component)Component.m_237113_((String)value).m_130940_(ChatFormatting.GRAY)));
        }

        @Nullable
        private void createTranslatedTooltip(String key, ChatFormatting color) {
            String translationKey = this.parser.getTranlsationKey(key);
            MutableComponent translatedComponent = Component.m_237115_((String)translationKey);
            if (!translatedComponent.getString().equals(translationKey)) {
                this.tooltips.add((Component)Component.m_237115_((String)("gui.structure_gel.data_handler." + key)).m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(color).m_7220_((Component)translatedComponent.m_130940_(ChatFormatting.GRAY)));
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.widget);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.widget);
        }

        public GuiEventListener m_7222_() {
            return this.widget;
        }

        public void m_6311_(PoseStack poseStack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            int maxWidth;
            DataParamsList dataParamsList = DataParamsList.this;
            int white = 0xFFFFFF;
            int red = 0xBA0000;
            Font font = ((DataParamsList)dataParamsList).f_93386_.f_91062_;
            int labelWidth = font.m_92852_((FormattedText)this.renderLabel);
            String labelToDraw = labelWidth > (maxWidth = 95) ? font.m_92854_((FormattedText)this.renderLabel, maxWidth).getString() + "..." : this.renderLabel.getString();
            font.m_92750_(poseStack, labelToDraw, (float)(rowLeft - 76), (float)(rowTop + rowHeight / 2 - 4), this.isValid ? white : red);
            this.widget.f_93620_ = rowLeft + 30;
            this.widget.f_93621_ = rowTop;
            if (!this.widget.m_93696_()) {
                this.widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            }
            if (!this.isValid) {
                font.m_92750_(poseStack, "\u2717", (float)(rowLeft - 89), (float)(rowTop + rowHeight / 2 - 4), red);
            }
            if (mouseX > rowLeft - 70 && mouseX < rowLeft + 30 && mouseY > rowTop - rowHeight + 20 && mouseY < rowTop + 20) {
                dataParamsList.hoveredEntry = this;
            }
        }

        public boolean tick() {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                editBox.m_94120_();
                String val = editBox.m_94155_();
                boolean bl = this.isValid = val != null && (val.isEmpty() || this.parser.validator.test(val));
                if (!this.isValid) {
                    return false;
                }
            }
            return true;
        }

        public String getValue() {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                return button.m_168883_().toString().toLowerCase(Locale.ENGLISH);
            }
            abstractWidget = this.widget;
            if (abstractWidget instanceof EditBox) {
                EditBox editBox = (EditBox)abstractWidget;
                return editBox.m_94155_();
            }
            StructureGelMod.LOGGER.error("Unhandled widget type for DataParamsList.Entry.getValue(): " + this.widget.getClass().getCanonicalName(), new Object[0]);
            return "unknown";
        }

        public void setValue(String value) {
            AbstractWidget abstractWidget = this.widget;
            if (abstractWidget instanceof CycleButton) {
                CycleButton button = (CycleButton)abstractWidget;
                button.m_168892_((Object)value);
            } else {
                abstractWidget = this.widget;
                if (abstractWidget instanceof EditBox) {
                    EditBox editBox = (EditBox)abstractWidget;
                    editBox.m_94144_(value);
                } else {
                    StructureGelMod.LOGGER.error("Unhandled widget type for DataParamsList.Entry.setValue(): " + this.widget.getClass().getCanonicalName(), new Object[0]);
                }
            }
        }
    }

    public static interface WidgetFactory {
        public AbstractWidget create(Minecraft var1, DataParser.Parser<?> var2);

        public static <T> AbstractWidget suggestionEditBox(Minecraft mc, DataParser.Parser<?> parser, Collection<T> suggestions, Function<T, String> toString) {
            SuggestionEditBox editBox = new SuggestionEditBox(mc.f_91062_, 0, 0, 190, 20, (Component)Component.m_237113_((String)""), 10, suggestions, toString);
            editBox.m_94199_(512);
            return editBox;
        }

        private static AbstractWidget suggestionEditBox(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.suggestionEditBox(mc, parser, parser.getSuggestions(), parser.getSuggestionToString());
        }

        public static AbstractWidget forgeRegistryEditBox(Minecraft mc, DataParser.Parser<?> parser, IForgeRegistry<?> registry) {
            return WidgetFactory.suggestionEditBox(mc, parser, registry.getKeys(), ResourceLocation::toString);
        }

        public static <T> AbstractWidget vanillaRegistryEditBox(Minecraft mc, DataParser.Parser<?> parser) {
            if (parser instanceof DataParser.ResourceKeyParser) {
                DataParser.ResourceKeyParser registryParser = (DataParser.ResourceKeyParser)parser;
                return WidgetFactory.suggestionEditBox(mc, registryParser, mc.f_91073_.m_5962_().m_175515_(registryParser.getRegistry()).m_6566_(), ResourceLocation::toString);
            }
            return WidgetFactory.suggestionEditBox(mc, parser);
        }

        private static AbstractWidget booleanButton(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.cycleButton(mc, parser, "true", "false");
        }

        private static AbstractWidget directionButton(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.cycleButton((Minecraft)mc, parser, Direction::m_122433_, (Enum[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN});
        }

        private static AbstractWidget axisButton(Minecraft mc, DataParser.Parser<?> parser) {
            return WidgetFactory.cycleButton((Minecraft)mc, parser, Direction.Axis::m_122477_, (Enum[])Direction.Axis.values());
        }

        public static <T extends Enum<T>> AbstractWidget cycleButton(Minecraft mc, DataParser.Parser<?> parser, Function<T, String> toString, T ... values) {
            return WidgetFactory.cycleButton(mc, parser, (String[])Arrays.stream(values).map(toString).toArray(String[]::new));
        }

        public static AbstractWidget cycleButton(Minecraft mc, DataParser.Parser<?> parser, String ... values) {
            CycleButton.Builder builder = CycleButton.m_168894_(s -> Component.m_237113_((String)(s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH))));
            builder.m_168929_();
            builder.m_168961_((Object[])values);
            return builder.m_168930_(0, 0, 60, 20, (Component)Component.m_237113_((String)""));
        }
    }
}

