/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.block_entity;

import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.core.block_entity.SGBlockEntity;
import com.legacy.structure_gel.core.dynamic_spawner.DynamicSpawner;
import com.legacy.structure_gel.core.registry.SGRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicSpawnerBlockEntity
extends SGBlockEntity {
    public static final String SPAWNER_ID_KEY = "SpawnerID";
    public static final String SPAWNER_KEY = "Spawner";
    private ResourceLocation spawnerID = DynamicSpawnerType.DEFAULT.getRegistryName();
    private DynamicSpawner spawner = DynamicSpawnerType.DEFAULT.createSpawner(this.f_58857_, this.f_58858_);

    public DynamicSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super(SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), pos, state);
    }

    public void setSpawner(DynamicSpawnerType type) {
        ResourceLocation newName = type.getRegistryName();
        if (!newName.equals((Object)this.spawnerID)) {
            this.spawnerID = newName;
            this.spawner = type.createSpawner(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(SPAWNER_ID_KEY, 8)) {
            ResourceLocation typeName = new ResourceLocation(tag.m_128461_(SPAWNER_ID_KEY));
            if (tag.m_128425_(SPAWNER_KEY, 10)) {
                this.spawnerID = typeName;
                this.spawner.m_151328_(this.f_58857_, this.f_58858_, tag.m_128469_(SPAWNER_KEY));
            } else {
                this.setSpawner(DynamicSpawnerType.REGISTRY.get(typeName));
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.spawnerID != null) {
            tag.m_128359_(SPAWNER_ID_KEY, this.spawnerID.toString());
        }
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, b -> {
            CompoundTag tag = this.serializeNBT();
            this.m_183515_(tag);
            CompoundTag spawnerTag = this.spawner.m_186381_(new CompoundTag());
            tag.m_128365_(SPAWNER_KEY, (Tag)spawnerTag);
            return tag;
        });
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, DynamicSpawnerBlockEntity blockEntity) {
        blockEntity.spawner.m_151319_(level, pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DynamicSpawnerBlockEntity blockEntity) {
        blockEntity.spawner.m_151311_((ServerLevel)level, pos);
    }

    public boolean m_7531_(int paramA, int paramB) {
        return this.spawner.m_151316_(this.f_58857_, paramA) ? true : super.m_7531_(paramA, paramB);
    }

    public boolean m_6326_() {
        return true;
    }

    public DynamicSpawner getSpawner() {
        return this.spawner;
    }
}

