/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.dimension;

import com.legacy.structure_gel.core.SGAccessor;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class DimensionAccessHelper {
    public static NoiseSettings overworldNoise() {
        return NoiseSettings.f_224519_;
    }

    public static NoiseSettings netherNoise() {
        return NoiseSettings.f_209630_;
    }

    public static NoiseSettings endNoise() {
        return NoiseSettings.f_209631_;
    }

    public static NoiseSettings cavesNoise() {
        return NoiseSettings.f_209632_;
    }

    public static NoiseSettings floatingIslandsNoise() {
        return NoiseSettings.f_209633_;
    }

    public static NoiseRouter noneNoiseRouter() {
        return SGAccessor.NOISE_ROUTER_DATA_NONE.invokeStatic(new Object[0]);
    }

    public static NoiseRouter overworldNoiseRouter(Registry<DensityFunction> registry, boolean largeBiomes, boolean isAmplified) {
        return SGAccessor.NOISE_ROUTER_DATA_OVERWORLD.invokeStatic(registry, largeBiomes, isAmplified);
    }

    public static NoiseRouter netherNoiseRouter(Registry<DensityFunction> registry) {
        return SGAccessor.NOISE_ROUTER_DATA_NETHER.invokeStatic(registry);
    }

    public static NoiseRouter endNoiseRouter(Registry<DensityFunction> registry) {
        return SGAccessor.NOISE_ROUTER_DATA_END.invokeStatic(registry);
    }

    public static NoiseRouter cavesNoiseRouter(Registry<DensityFunction> registry) {
        return SGAccessor.NOISE_ROUTER_DATA_CAVES.invokeStatic(registry);
    }

    public static NoiseRouter floatingIslandsNoiseRouter(Registry<DensityFunction> registry) {
        return SGAccessor.NOISE_ROUTER_DATA_FLOATING_ISLANDS.invokeStatic(registry);
    }

    public static NoiseGeneratorSettings newDimensionSettings(NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, NoiseRouter noiseRouter, SurfaceRules.RuleSource surfaceRule, int seaLevel, boolean useLegacyRandomSource) {
        return DimensionAccessHelper.newDimensionSettings(noise, defaultBlock, defaultFluid, noiseRouter, surfaceRule, seaLevel, false, false, false, useLegacyRandomSource);
    }

    public static NoiseGeneratorSettings newDimensionSettings(NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, NoiseRouter noiseRouter, SurfaceRules.RuleSource surfaceRule, int seaLevel, boolean disableMobGeneration, boolean aquifersEnabled, boolean oreVeinsEnabled, boolean useLegacyRandomSource) {
        return DimensionAccessHelper.newDimensionSettings(noise, defaultBlock, defaultFluid, noiseRouter, surfaceRule, List.of(), seaLevel, disableMobGeneration, aquifersEnabled, oreVeinsEnabled, useLegacyRandomSource);
    }

    public static NoiseGeneratorSettings newDimensionSettings(NoiseSettings noise, BlockState defaultBlock, BlockState defaultFluid, NoiseRouter noiseRouter, SurfaceRules.RuleSource surfaceRule, List<Climate.ParameterPoint> spawnTarget, int seaLevel, boolean disableMobGeneration, boolean aquifersEnabled, boolean oreVeinsEnabled, boolean useLegacyRandomSource) {
        return new NoiseGeneratorSettings(noise, defaultBlock, defaultFluid, noiseRouter, surfaceRule, spawnTarget, seaLevel, disableMobGeneration, aquifersEnabled, oreVeinsEnabled, useLegacyRandomSource);
    }

    public static NoiseGeneratorSettings newOverworldLikeSettings(boolean isAmplified, boolean largeBiomes, BlockState defaultBlock, BlockState defaultFluid) {
        return DimensionAccessHelper.newOverworldLikeSettings(isAmplified, largeBiomes, defaultBlock, defaultFluid, (Registry<DensityFunction>)BuiltinRegistries.f_211085_);
    }

    public static NoiseGeneratorSettings newFloatingIslandSettings(BlockState defaultBlock, BlockState defaultFluid) {
        return DimensionAccessHelper.newFloatingIslandsSettings(defaultBlock, defaultFluid, (Registry<DensityFunction>)BuiltinRegistries.f_211085_);
    }

    public static NoiseGeneratorSettings newCavesSettings(BlockState defaultBlock, BlockState defaultFluid) {
        return DimensionAccessHelper.newCavesSettings(defaultBlock, defaultFluid, (Registry<DensityFunction>)BuiltinRegistries.f_211085_);
    }

    public static NoiseGeneratorSettings newOverworldLikeSettings(boolean isAmplified, boolean largeBiomes, BlockState defaultBlock, BlockState defaultFluid, Registry<DensityFunction> densityFunctionRegistry) {
        return new NoiseGeneratorSettings(NoiseSettings.f_224519_, defaultBlock, defaultFluid, DimensionAccessHelper.overworldNoiseRouter(densityFunctionRegistry, largeBiomes, isAmplified), SurfaceRuleData.m_194807_(), new OverworldBiomeBuilder().m_187154_(), 63, false, true, true, false);
    }

    public static NoiseGeneratorSettings newFloatingIslandsSettings(BlockState defaultBlock, BlockState defaultFluid, Registry<DensityFunction> densityFunctionRegistry) {
        return new NoiseGeneratorSettings(NoiseSettings.f_209633_, defaultBlock, defaultFluid, DimensionAccessHelper.floatingIslandsNoiseRouter(densityFunctionRegistry), SurfaceRuleData.m_198380_((boolean)false, (boolean)false, (boolean)false), new OverworldBiomeBuilder().m_187154_(), -64, false, false, false, true);
    }

    public static NoiseGeneratorSettings newCavesSettings(BlockState defaultBlock, BlockState defaultFluid, Registry<DensityFunction> densityFunctionRegistry) {
        return new NoiseGeneratorSettings(NoiseSettings.f_209632_, defaultBlock, defaultFluid, DimensionAccessHelper.cavesNoiseRouter(densityFunctionRegistry), SurfaceRuleData.m_198380_((boolean)false, (boolean)true, (boolean)true), new OverworldBiomeBuilder().m_187154_(), 32, false, false, false, true);
    }
}

