/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block_entity;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerAccessHelper {
    public static void setMinSpawnDelay(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int minSpawnelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MinSpawnDelay", (short)minSpawnelay));
    }

    public static void setMaxSpawnDelay(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int maxSpawnDelay) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MaxSpawnDelay", (short)maxSpawnDelay));
    }

    public static void setSpawnCount(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int spawnCount) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("SpawnCount", (short)spawnCount));
    }

    public static void setMaxNearbyEntities(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int maxNearbyEntities) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("MaxNearbyEntities", (short)maxNearbyEntities));
    }

    public static void setRequiredPlayerRange(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int requiredPlayerRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("RequiredPlayerRange", (short)requiredPlayerRange));
    }

    public static void setSpawnRange(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, int spawnRange) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> nbt.m_128376_("SpawnRange", (short)spawnRange));
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, EntityType<?> entityType) {
        SpawnerAccessHelper.setSpawnPotentials(tile, level, pos, SpawnerAccessHelper.createSpawnerEntity(entityType));
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, SpawnData ... spawnDatas) {
        SimpleWeightedRandomList list = ((SimpleWeightedRandomList.Builder)Util.m_137469_((Object)new SimpleWeightedRandomList.Builder(), builder -> {
            for (SpawnData data : spawnDatas) {
                builder.m_146271_((Object)data, 1);
            }
        })).m_146270_();
        SpawnerAccessHelper.setSpawnPotentials(tile, level, pos, (SimpleWeightedRandomList<SpawnData>)list);
    }

    public static void setSpawnPotentials(SpawnerBlockEntity tile, @Nullable Level level, BlockPos pos, SimpleWeightedRandomList<SpawnData> spawnDatas) {
        SpawnerAccessHelper.modifySpawnerNBT(tile, level, pos, nbt -> {
            if (!spawnDatas.m_146337_()) {
                nbt.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((SpawnData)((WeightedEntry.Wrapper)spawnDatas.m_216829_(level != null ? level.f_46441_ : RandomSource.m_216327_()).get()).m_146310_())).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
                nbt.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)spawnDatas).result().orElseThrow());
            }
        });
    }

    public static SpawnData createSpawnerEntity(EntityType<?> entity) {
        return SpawnerAccessHelper.createSpawnerEntity(entity, new CompoundTag(), Optional.empty());
    }

    public static SpawnData createSpawnerEntity(EntityType<?> entity, CompoundTag entityTag, Optional<SpawnData.CustomSpawnRules> customSpawnRules) {
        CompoundTag nbt = entityTag.m_6426_();
        ResourceLocation name = ForgeRegistries.ENTITY_TYPES.getKey(entity);
        nbt.m_128359_("id", name != null ? ForgeRegistries.ENTITY_TYPES.getKey(entity).toString() : "pig");
        return new SpawnData(nbt, customSpawnRules);
    }

    public static void modifySpawnerNBT(SpawnerBlockEntity spawner, @Nullable Level level, BlockPos pos, Consumer<CompoundTag> nbtConsumer) {
        CompoundTag nbt = new CompoundTag();
        spawner.m_59801_().m_186381_(nbt);
        nbtConsumer.accept(nbt);
        spawner.m_59801_().m_151328_(null, pos, nbt);
    }
}

