/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.Tags;

public class TagKeyArgument<T>
implements ArgumentType<TagKey<T>> {
    private static final List<String> EXAMPLES = Arrays.asList("#" + BlockTags.f_144282_.f_203868_().toString(), "#" + Tags.Items.DYES.f_203868_().toString(), "#" + BiomeTags.f_215803_.f_203868_().toString());
    private static final DynamicCommandExceptionType NOT_A_TAG = new DynamicCommandExceptionType(tag -> Component.m_237110_((String)"commands.simplyhotsprings.biometags.not_a_tag", (Object[])new Object[]{tag}));
    public final ResourceKey<? extends Registry<T>> registryKey;

    private TagKeyArgument(ResourceKey<? extends Registry<T>> registryKey) {
        this.registryKey = registryKey;
    }

    public static <T> TagKeyArgument<T> tagKeyArgument(ResourceKey<? extends Registry<T>> registryKey) {
        return new TagKeyArgument<T>(registryKey);
    }

    public static <T> TagKey<T> get(CommandContext<CommandSourceStack> context, String name, ResourceKey<Registry<T>> registry, DynamicCommandExceptionType exception) throws CommandSyntaxException {
        TagKey result = (TagKey)context.getArgument(name, TagKey.class);
        Optional optional = result.m_207647_(registry);
        return (TagKey)optional.orElseThrow(() -> exception.create((Object)("#" + result)));
    }

    public TagKey<T> parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '#') {
            int i = reader.getCursor();
            try {
                reader.skip();
                ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
                return TagKey.m_203882_(this.registryKey, (ResourceLocation)id);
            }
            catch (CommandSyntaxException excep) {
                reader.setCursor(i);
                throw excep;
            }
        }
        throw NOT_A_TAG.create((Object)reader.readUnquotedString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)object;
            return sharedsuggestionprovider.m_212095_(this.registryKey, SharedSuggestionProvider.ElementSuggestionType.TAGS, builder, context);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info<T>
    implements ArgumentTypeInfo<TagKeyArgument<T>, Template> {
        public void serializeToNetwork(Template p_233278_, FriendlyByteBuf p_233279_) {
            p_233279_.m_130085_(p_233278_.registryKey.m_135782_());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf p_233289_) {
            ResourceLocation resourcelocation = p_233289_.m_130281_();
            return new Template(ResourceKey.m_135788_((ResourceLocation)resourcelocation));
        }

        public void serializeToJson(Template p_233275_, JsonObject p_233276_) {
            p_233276_.addProperty("registry", p_233275_.registryKey.m_135782_().toString());
        }

        public Template unpack(TagKeyArgument<T> p_233281_) {
            return new Template(p_233281_.registryKey);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TagKeyArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> p_233296_) {
                this.registryKey = p_233296_;
            }

            public TagKeyArgument<T> instantiate(CommandBuildContext p_233299_) {
                return new TagKeyArgument(this.registryKey);
            }

            public ArgumentTypeInfo<TagKeyArgument<T>, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

