/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.util;

import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.HashBasedTable;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import connor135246.simplyhotsprings.SimplyHotSprings;
import connor135246.simplyhotsprings.common.world.gen.AddHotSpringsBiomeModifier;
import connor135246.simplyhotsprings.common.world.gen.feature.HotSpringsFeature;
import connor135246.simplyhotsprings.util.GenerationReason;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="simplyhotsprings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplyHotSpringsConfig {
    @Nullable
    private static MobEffect potionEffect = null;
    public static final HashBasedTable<Holder<Biome>, ResourceLocation, GenerationReason> biomeModifierReasons = HashBasedTable.create((int)180, (int)1);
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    private static void warnInvalidEntry(String config, String input) {
        SimplyHotSprings.log.warn("Config: \"" + config + "\" entry with \"" + input + "\" is invalid");
    }

    private static void updateEffect() {
        String input = (String)SimplyHotSpringsConfig.SERVER.potionEffect.get();
        if (StringUtils.isBlank((CharSequence)input)) {
            potionEffect = null;
        } else {
            potionEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(input));
            if (potionEffect == null) {
                SimplyHotSpringsConfig.warnInvalidEntry("Potion Effect", input);
            }
        }
    }

    @Nullable
    public static MobEffectInstance getNewHotSpringsEffect() {
        return potionEffect == null ? null : new MobEffectInstance(potionEffect, ((Integer)SimplyHotSpringsConfig.SERVER.potionEffectTimer.get()).intValue(), ((Integer)SimplyHotSpringsConfig.SERVER.potionEffectAmplifier.get()).intValue(), true, true);
    }

    public static boolean addHotSpringsEffect(LivingEntity livingEntity) {
        if (potionEffect != null && !livingEntity.m_21023_(potionEffect)) {
            return livingEntity.m_7292_(SimplyHotSpringsConfig.getNewHotSpringsEffect());
        }
        return false;
    }

    public static void finalizeSpringsGeneration(ServerAboutToStartEvent event) {
        event.getServer().m_206579_().m_6632_(Registry.f_122885_).ifPresent(biomeReg -> {
            for (String input : (List)SimplyHotSpringsConfig.SERVER.biomeGrasses.get()) {
                BlockState state;
                Holder holder;
                String[] parts = input.split(";");
                if (parts.length < 2) {
                    SimplyHotSpringsConfig.warnInvalidEntry("Biome Grasses", input);
                }
                try {
                    holder = biomeReg.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(parts[0])));
                }
                catch (IllegalStateException excep) {
                    SimplyHotSpringsConfig.warnInvalidEntry("Biome Grasses", parts[0]);
                    continue;
                }
                try {
                    state = BlockStateParser.m_234704_((Registry)Registry.f_122824_, (String)parts[1], (boolean)false).f_234748_();
                }
                catch (CommandSyntaxException excep) {
                    SimplyHotSpringsConfig.warnInvalidEntry("Biome Grasses", parts[1]);
                    continue;
                }
                HotSpringsFeature.addBiomeGrass((Holder<Biome>)holder, state);
            }
        });
    }

    public static void resetSpringsGeneration(ServerStoppedEvent event) {
        biomeModifierReasons.clear();
        AddHotSpringsBiomeModifier.warned.clear();
        HotSpringsFeature.clearBiomeGrasses();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        SimplyHotSpringsConfig.onReOrLoad((ModConfigEvent)event);
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        SimplyHotSpringsConfig.onReOrLoad((ModConfigEvent)event);
    }

    private static void onReOrLoad(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            SimplyHotSpringsConfig.updateEffect();
        }
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        SERVER = (Server)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Server {
        public static final String LANG_CONFIG = "simplyhotsprings.config.";
        public final ForgeConfigSpec.BooleanValue createsSources;
        public final ForgeConfigSpec.ConfigValue<String> potionEffect;
        public final ForgeConfigSpec.IntValue potionEffectTimer;
        public final ForgeConfigSpec.IntValue potionEffectAmplifier;
        public static final String LANG_CONFIG_WORLDGEN = "simplyhotsprings.config.worldgen.";
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> info;
        public final ForgeConfigSpec.BooleanValue worldGenDefault;
        public final ForgeConfigSpec.BooleanValue worldGenBig;
        public final ForgeConfigSpec.BooleanValue worldGenWellsprings;
        public final ForgeConfigSpec.BooleanValue debug;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeGrasses;
        private static final Pattern biomeGrassesPat = Pattern.compile("[\\w\\.\\-]+:[\\w\\.\\-/]+;[\\w\\.\\-]+:[\\w\\.\\-/]+(\\[[\\w\\.\\-/=,]+])?");

        Server(ForgeConfigSpec.Builder builder) {
            Config.setInsertionOrderPreserved((boolean)true);
            this.createsSources = builder.translation("simplyhotsprings.config.createsSources").comment("If true, Hot Spring Water makes infinite water sources, like vanilla water does.").define("Creates Source Blocks", true);
            this.potionEffect = builder.translation("simplyhotsprings.config.potionEffect").comment("The namespaced effect that Hot Spring Water applies to entities. If the given effect isn't found (or left blank), no effect is applied.").define("Potion Effect", (Object)"minecraft:regeneration");
            this.potionEffectTimer = builder.translation("simplyhotsprings.config.potionEffectTimer").comment("The duration of the effect, in ticks. 20 ticks = 1 second.").defineInRange("Potion Effect Timer", 50, 1, Integer.MAX_VALUE);
            this.potionEffectAmplifier = builder.translation("simplyhotsprings.config.potionEffectAmplifier").comment("The amplifier of the effect. 0 is level 1.").defineInRange("Potion Effect Amplifier", 0, 0, 255);
            builder.comment("Some of these settings require any open world to be closed and reopened.").push("worldgen");
            this.info = builder.translation("simplyhotsprings.config.worldgen.info").comment(new String[]{"By default, Hot Springs only generate in biomes that are not in the \"simplyhotsprings:hot_springs_blacklist\" biome tag.", "The command \"/simplyhotsprings\" has a few subcommands that will help you test your Hot Springs.To see how to use \"/simplyhotsprings\", run the command \"/simplyhotsprings help\".", "For more useful information, visit the wiki at https://github.com/connor135246/Simply-Hot-Springs/wiki", "(Also, this config setting does nothing, so put whatever you want in here.)"}).defineListAllowEmpty(Arrays.asList("#HOW TO"), () -> Arrays.asList("You can find screenshots of the different types of Hot Springs at https://github.com/connor135246/Simply-Hot-Springs/wiki/Hot-Spring-Types"), input -> true);
            this.worldGenDefault = builder.translation("simplyhotsprings.config.worldgen.worldGenDefault").comment(new String[]{"Controls whether \"default\" Hot Springs generate.", "These are the normal Hot Springs. They look just like vanilla's pre-1.18 water lakes. They generate on the surface in most biomes and are somewhat rare.", "If you change this setting with a world open, it must be closed and reopened for the changes to take effect."}).worldRestart().define("Enable \"Default\" Hot Springs", true);
            this.worldGenBig = builder.translation("simplyhotsprings.config.worldgen.worldGenBig").comment(new String[]{"Controls whether \"big\" Hot Springs generate.", "These look like the normal Hot Springs, but are much wider and deeper. They're also rarer than normal Hot Springs.", "If you change this setting with a world open, it must be closed and reopened for the changes to take effect."}).worldRestart().define("Enable \"Big\" Hot Springs", false);
            this.worldGenWellsprings = builder.translation("simplyhotsprings.config.worldgen.worldGenWellsprings").comment(new String[]{"Controls whether \"wellspring\" and \"big_wellspring\" Hot Springs generate.", "Wellsprings are geysers of Hot Spring Water that pour out of the ground and into the air. Follow them underground to find large pockets of Hot Spring Water. Big wellsprings are rarer and may have lava lakes below them.", "If you change this setting with a world open, it must be closed and reopened for the changes to take effect."}).worldRestart().define("Enable \"Wellspring\" Hot Springs", false);
            this.debug = builder.translation("simplyhotsprings.config.worldgen.debug").comment("When a Hot Spring generates in the world, prints the location to console.").define("Generation Debug", false);
            this.biomeGrasses = builder.translation("simplyhotsprings.config.worldgen.biomeGrasses").comment(new String[]{"A list of biomes and their specific types of grass.", "By default, dirt around Hot Springs will be turned into grass. But some biomes have their own specific grass type which you need to tell Simply Hot Springs about.", "The format is \"modid:biome;modid:block[states]\".", "If you change this setting with a world open, it must be closed and reopened for the changes to take effect."}).worldRestart().defineListAllowEmpty(Arrays.asList("Biome Grasses"), () -> Arrays.asList("minecraft:mushroom_fields;minecraft:mycelium", "biomesoplenty:origin_valley;biomesoplenty:origin_grass_block", "biomesoplenty:redwood_forest;minecraft:podzol"), Server::biomeGrassesPat);
            builder.pop();
        }

        private static boolean biomeGrassesPat(Object object) {
            return object instanceof String ? biomeGrassesPat.matcher((String)object).matches() : false;
        }
    }

    public static class Client {
        public static final String LANG_CLIENT = "simplyhotsprings.config.client.";
        public final ForgeConfigSpec.BooleanValue alternateParticles;

        Client(ForgeConfigSpec.Builder builder) {
            this.alternateParticles = builder.translation("simplyhotsprings.config.client.alternateParticles").comment("If true, Hot Spring Water makes smaller, less obtrusive steam particles instead.").define("Alternate Particles", false);
        }
    }
}

