/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.common.world.gen.feature;

import com.mojang.serialization.Codec;
import connor135246.simplyhotsprings.SimplyHotSprings;
import connor135246.simplyhotsprings.common.world.gen.feature.HotSpringsConfiguration;
import connor135246.simplyhotsprings.util.SimplyHotSpringsConfig;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;

public class HotSpringsFeature
extends Feature<HotSpringsConfiguration> {
    private static final Object2ObjectOpenHashMap<Holder<Biome>, BlockState> biomeGrasses = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(10, 0.95f), map -> map.defaultReturnValue((Object)Blocks.f_50440_.m_49966_()));

    public HotSpringsFeature(Codec<HotSpringsConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HotSpringsConfiguration> context) {
        int y;
        int x;
        WorldGenLevel glevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos origin = context.m_159777_();
        HotSpringsConfiguration config = (HotSpringsConfiguration)context.m_159778_();
        if (origin.m_123342_() < glevel.m_141937_() + config.featureSizeXZ() / 2 + 1) {
            return false;
        }
        BlockPos pos = origin.m_6625_(config.featureSizeY() / 2);
        boolean postProcess = glevel.m_46865_(pos).m_6415_().m_62494_() != ChunkStatus.ChunkType.LEVELCHUNK;
        boolean[] blocksChanged = new boolean[config.featureSizeXZ() * config.featureSizeXZ() * config.featureSizeY()];
        int spheres = config.spheres().m_214085_(rand);
        int sphereDiameterXZExtraBelowLevelValue = config.sphereDiameterXZExtraBelowLevel().m_214085_(rand);
        for (int s = 0; s < spheres; ++s) {
            double diameterY = config.sphereDiameterY().m_214084_(rand);
            double centerY = rand.m_188500_() * ((double)config.featureSizeY() - diameterY - (double)(config.spherePaddingY() * 2.0f)) + (double)config.spherePaddingY() + diameterY / 2.0;
            double diameterX = config.sphereDiameterXZ().m_214084_(rand);
            double diameterZ = config.sphereDiameterXZ().m_214084_(rand);
            if (sphereDiameterXZExtraBelowLevelValue != 0 && (sphereDiameterXZExtraBelowLevelValue > 0 ? centerY < (double)sphereDiameterXZExtraBelowLevelValue : centerY > (double)(config.featureSizeY() + sphereDiameterXZExtraBelowLevelValue))) {
                diameterX += (double)config.sphereDiameterXZExtra().m_214084_(rand);
                diameterZ += (double)config.sphereDiameterXZExtra().m_214084_(rand);
            }
            double centerX = rand.m_188500_() * ((double)config.featureSizeXZ() - diameterX - (double)(config.spherePaddingXZ() * 2.0f)) + (double)config.spherePaddingXZ() + diameterX / 2.0;
            double centerZ = rand.m_188500_() * ((double)config.featureSizeXZ() - diameterZ - (double)(config.spherePaddingXZ() * 2.0f)) + (double)config.spherePaddingXZ() + diameterZ / 2.0;
            for (int x2 = 1; x2 < config.featureSizeXZ() - 1; ++x2) {
                for (int z = 1; z < config.featureSizeXZ() - 1; ++z) {
                    for (int y2 = 1; y2 < config.featureSizeY() - 1; ++y2) {
                        double xRadii = ((double)x2 - centerX) / (diameterX / 2.0);
                        double yRadii = ((double)y2 - centerY) / (diameterY / 2.0);
                        double zRadii = ((double)z - centerZ) / (diameterZ / 2.0);
                        double radiiSquared = xRadii * xRadii + yRadii * yRadii + zRadii * zRadii;
                        if (!(radiiSquared < 1.0)) continue;
                        blocksChanged[(x2 * config.featureSizeXZ() + z) * config.featureSizeY() + y2] = true;
                    }
                }
            }
        }
        BlockState theFluid = config.fluid().m_213972_(rand, pos);
        boolean normalFluid = config.fluidLevel() >= 0;
        for (x = 0; x < config.featureSizeXZ(); ++x) {
            for (int z = 0; z < config.featureSizeXZ(); ++z) {
                for (y = 0; y < config.featureSizeY(); ++y) {
                    if (!HotSpringsFeature.isBorderPos(config, blocksChanged, x, y, z)) continue;
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockState checkState = glevel.m_8055_(checkPos);
                    if (!(HotSpringsFeature.isWithinSolidCheckBelowLevel(config, y) ? !checkState.m_60767_().m_76333_() && !checkState.m_60713_(theFluid.m_60734_()) : checkState.m_60767_().m_76332_())) continue;
                    return false;
                }
            }
        }
        if (((Boolean)SimplyHotSpringsConfig.SERVER.debug.get()).booleanValue()) {
            SimplyHotSprings.log.info("Generated a hot spring around {} {} {}", (Object)(pos.m_123341_() + config.featureSizeXZ() / 2), (Object)(pos.m_123342_() + config.featureSizeY() / 2), (Object)(pos.m_123343_() + config.featureSizeXZ() / 2));
        }
        for (x = 0; x < config.featureSizeXZ(); ++x) {
            for (int z = 0; z < config.featureSizeXZ(); ++z) {
                for (y = 0; y < config.featureSizeY(); ++y) {
                    BlockPos belowPos;
                    BlockState belowState;
                    if (!blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + y]) continue;
                    BlockPos setPos = pos.m_7918_(x, y, z);
                    BlockState setState = theFluid;
                    boolean didSetFluid = false;
                    if (HotSpringsFeature.canReplaceBlock(glevel.m_8055_(setPos))) {
                        FluidState fluidState;
                        if (!HotSpringsFeature.isWithinFluidLevel(config, y)) {
                            setState = Blocks.f_50016_.m_49966_();
                        } else {
                            fluidState = setState.m_60819_();
                            if (!fluidState.m_76178_() && fluidState.getFluidType().isVaporizedOnPlacement((Level)glevel.m_6018_(), setPos, new FluidStack(fluidState.m_76152_(), 1000))) {
                                if (setState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                                    setState = (BlockState)setState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                                } else if (setState.m_60734_() == fluidState.m_76188_().m_60734_()) {
                                    setState = Blocks.f_50016_.m_49966_();
                                }
                            }
                        }
                        didSetFluid = glevel.m_7731_(setPos, setState, 2);
                        fluidState = setState.m_60819_();
                        if (!fluidState.m_76178_()) {
                            glevel.m_186469_(setPos, fluidState.m_76152_(), 0);
                        }
                        if (setState.m_60795_()) {
                            glevel.m_186460_(setPos, setState.m_60734_(), 0);
                        }
                    }
                    if ((y <= 0 || !blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + (y - 1)]) && HotSpringsFeature.canReplaceBlock(belowState = glevel.m_8055_(belowPos = pos.m_7918_(x, y - 1, z)))) {
                        if (!HotSpringsFeature.isWithinFluidLevel(config, y)) {
                            Holder biome = glevel.m_204166_(pos);
                            boolean isCrimsonForest = biome.m_203425_(key -> key == Biomes.f_48200_);
                            if ((isCrimsonForest || biome.m_203425_(key -> key == Biomes.f_48201_)) && belowState.m_60713_(Blocks.f_50134_) && glevel.m_46859_(belowPos.m_7494_())) {
                                glevel.m_7731_(belowPos, isCrimsonForest ? Blocks.f_50699_.m_49966_() : Blocks.f_50690_.m_49966_(), 2);
                            }
                            if (belowState.m_60713_(Blocks.f_50493_) && glevel.m_46859_(belowPos.m_7494_())) {
                                glevel.m_7731_(belowPos, (BlockState)biomeGrasses.get((Object)biome), 2);
                            }
                        } else if (normalFluid) {
                            HotSpringsFeature.modifyBlocksHoldingFluid(belowPos, belowState, glevel);
                        }
                    }
                    if (y < config.featureSizeY() - 1 && blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + (y + 1)]) continue;
                    BlockPos abovePos = pos.m_7918_(x, y + 1, z);
                    BlockState aboveState = glevel.m_8055_(abovePos);
                    boolean didSetAbove = false;
                    if (!normalFluid && HotSpringsFeature.canReplaceBlock(aboveState) && HotSpringsFeature.isWithinFluidLevel(config, y)) {
                        didSetAbove = HotSpringsFeature.modifyBlocksHoldingFluid(abovePos, aboveState, glevel);
                    }
                    if (!postProcess) continue;
                    if (didSetAbove) {
                        this.m_159739_(glevel, abovePos);
                        continue;
                    }
                    if (!didSetFluid) continue;
                    this.m_159739_(glevel, setPos);
                }
            }
        }
        if (config.barrier().isPresent()) {
            for (x = 0; x < config.featureSizeXZ(); ++x) {
                for (int z = 0; z < config.featureSizeXZ(); ++z) {
                    for (y = 0; y < config.featureSizeY(); ++y) {
                        BlockPos borderPos;
                        BlockState borderState;
                        if (!HotSpringsFeature.isBorderPos(config, blocksChanged, x, y, z) || !HotSpringsFeature.isWithinFluidLevel(config, y) && rand.m_188503_(2) == 0 || !(borderState = glevel.m_8055_(borderPos = pos.m_7918_(x, y, z))).m_60767_().m_76333_() || borderState.m_204336_(BlockTags.f_144288_)) continue;
                        glevel.m_7731_(borderPos, config.barrier().get().m_213972_(rand, borderPos), 2);
                        if (!postProcess) continue;
                        this.m_159739_(glevel, borderPos);
                    }
                }
            }
        }
        if (config.additionalPlacedFeatures().isPresent()) {
            config.additionalPlacedFeatures().get().forEach(placedFeature -> ((PlacedFeature)placedFeature.get()).m_226357_(glevel, context.m_159775_(), rand, pos));
        }
        return true;
    }

    private static boolean modifyBlocksHoldingFluid(BlockPos pos, BlockState state, WorldGenLevel glevel) {
        if (state.m_60767_().m_76333_()) {
            if (HotSpringsFeature.m_159759_((BlockState)state) || state.m_204336_(BlockTags.f_144279_) || state.m_204336_(BlockTags.f_13047_)) {
                return glevel.m_7731_(pos, Blocks.f_50069_.m_49966_(), 2);
            }
            if (state.m_60713_(Blocks.f_49992_)) {
                return glevel.m_7731_(pos, Blocks.f_50062_.m_49966_(), 2);
            }
            if (state.m_60713_(Blocks.f_49993_)) {
                return glevel.m_7731_(pos, Blocks.f_50394_.m_49966_(), 2);
            }
        }
        return false;
    }

    private static boolean isWithinFluidLevel(HotSpringsConfiguration config, int y) {
        return config.fluidLevel() >= 0 ? y <= config.fluidLevel() : y >= config.featureSizeY() + config.fluidLevel();
    }

    private static boolean isWithinSolidCheckBelowLevel(HotSpringsConfiguration config, int y) {
        return config.solidCheckBelowLevel() >= 0 ? y < config.solidCheckBelowLevel() : y > config.featureSizeY() + config.solidCheckBelowLevel();
    }

    private static boolean isBorderPos(HotSpringsConfiguration config, boolean[] blocksChanged, int x, int y, int z) {
        return !blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + y] && (x < config.featureSizeXZ() - 1 && blocksChanged[((x + 1) * config.featureSizeXZ() + z) * config.featureSizeY() + y] || x > 0 && blocksChanged[((x - 1) * config.featureSizeXZ() + z) * config.featureSizeY() + y] || z < config.featureSizeXZ() - 1 && blocksChanged[(x * config.featureSizeXZ() + z + 1) * config.featureSizeY() + y] || z > 0 && blocksChanged[(x * config.featureSizeXZ() + (z - 1)) * config.featureSizeY() + y] || y < config.featureSizeY() - 1 && blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + y + 1] || y > 0 && blocksChanged[(x * config.featureSizeXZ() + z) * config.featureSizeY() + (y - 1)]);
    }

    private static boolean canReplaceBlock(BlockState state) {
        return !state.m_204336_(BlockTags.f_144287_);
    }

    public static void addBiomeGrass(Holder<Biome> biome, BlockState state) {
        biomeGrasses.put(biome, (Object)state);
    }

    public static void clearBiomeGrasses() {
        biomeGrasses.clear();
    }
}

