/*
 * Decompiled with CFR 0.152.
 */
package connor135246.simplyhotsprings.client.particles;

import connor135246.simplyhotsprings.common.SimplyHotSpringsCommon;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;

public abstract class HotSpringWaterDripParticle
extends TextureSheetParticle {
    @Nullable
    protected final ParticleOptions nextParticle;

    public HotSpringWaterDripParticle(ClientLevel clevel, double x, double y, double z, @Nullable ParticleOptions nextParticle) {
        super(clevel, x, y, z);
        this.nextParticle = nextParticle;
        this.setup();
    }

    public HotSpringWaterDripParticle(ClientLevel clevel, double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable ParticleOptions nextParticle) {
        super(clevel, x, y, z, motionX, motionY, motionZ);
        this.nextParticle = nextParticle;
        this.setup();
    }

    private void setup() {
        this.m_107250_(0.01f, 0.01f);
        this.m_107253_(0.01f, 1.0f, 1.0f);
        this.f_107226_ = 0.06f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.ageParticle();
        if (this.m_107276_()) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.updateMotion();
            if (this.m_107276_()) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                this.checkBlockState();
            }
        }
    }

    protected void ageParticle() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void updateMotion() {
    }

    protected void checkBlockState() {
        BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
        if (fluidstate.m_205070_(SimplyHotSpringsCommon.TAG_HOT_SPRING_WATER) && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
            this.m_107274_();
        }
    }

    protected void spawnNextParticle(boolean copyMotion) {
        if (this.nextParticle != null) {
            this.f_107208_.m_7106_(this.nextParticle, this.f_107212_, this.f_107213_, this.f_107214_, copyMotion ? this.f_107215_ : 0.0, copyMotion ? this.f_107216_ : 0.0, copyMotion ? this.f_107217_ : 0.0);
        }
    }

    public static class SplashingProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SplashingProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clevel, double x, double y, double z, double motionX, double motionY, double motionZ) {
            Splashing particle = new Splashing(clevel, x, y, z, motionX, motionY, motionZ);
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }

    public static class FallingProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public FallingProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clevel, double x, double y, double z, double motionX, double motionY, double motionZ) {
            Falling particle = new Falling(clevel, x, y, z, (ParticleOptions)SimplyHotSpringsCommon.SPLASHING_HOT_SPRING_WATER.orElse(null));
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }

    public static class DrippingProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public DrippingProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel clevel, double x, double y, double z, double motionX, double motionY, double motionZ) {
            Dripping particle = new Dripping(clevel, x, y, z, (ParticleOptions)SimplyHotSpringsCommon.FALLING_HOT_SPRING_WATER.orElse(null));
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }

    public static class Splashing
    extends HotSpringWaterDripParticle {
        protected Splashing(ClientLevel clevel, double x, double y, double z, double motionX, double motionY, double motionZ) {
            super(clevel, x, y, z, 0.0, 0.0, 0.0, null);
            if (motionY == 0.0 && (motionX != 0.0 || motionZ != 0.0)) {
                this.f_107215_ = motionX;
                this.f_107216_ = 0.1;
                this.f_107217_ = motionZ;
            } else {
                this.f_107215_ *= (double)0.3f;
                this.f_107216_ = Math.random() * (double)0.2f + (double)0.1f;
                this.f_107217_ *= (double)0.3f;
            }
            this.f_107226_ = 0.04f;
            this.f_107225_ = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                if (Math.random() < 0.5) {
                    this.m_107274_();
                } else {
                    this.f_107215_ *= (double)0.7f;
                    this.f_107217_ *= (double)0.7f;
                }
            }
        }

        @Override
        protected void checkBlockState() {
            BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
            double collisionHeight = Math.max(this.f_107208_.m_8055_(blockpos).m_60812_((BlockGetter)this.f_107208_, blockpos).m_83290_(Direction.Axis.Y, this.f_107212_ - (double)blockpos.m_123341_(), this.f_107214_ - (double)blockpos.m_123343_()), (double)this.f_107208_.m_6425_(blockpos).m_76155_((BlockGetter)this.f_107208_, blockpos));
            if (collisionHeight > 0.0 && this.f_107213_ < (double)blockpos.m_123342_() + collisionHeight) {
                this.m_107274_();
            }
        }
    }

    public static class Falling
    extends HotSpringWaterDripParticle {
        public Falling(ClientLevel clevel, double x, double y, double z, @Nullable ParticleOptions nextParticle) {
            super(clevel, x, y, z, nextParticle);
            this.f_107225_ = (int)(64.0 / (Math.random() * 0.8 + 0.2));
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                this.m_107274_();
                this.spawnNextParticle(false);
            }
        }
    }

    public static class Dripping
    extends HotSpringWaterDripParticle {
        public Dripping(ClientLevel clevel, double x, double y, double z, @Nullable ParticleOptions nextParticle) {
            super(clevel, x, y, z, nextParticle);
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
        }

        @Override
        protected void ageParticle() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.spawnNextParticle(true);
            }
        }

        @Override
        protected void updateMotion() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

