/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.item.forge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.talhanation.smallships.world.item.BriggItem;
import com.talhanation.smallships.world.item.CannonBallItem;
import com.talhanation.smallships.world.item.CannonItem;
import com.talhanation.smallships.world.item.CogItem;
import com.talhanation.smallships.world.item.DrakkarItem;
import com.talhanation.smallships.world.item.GalleyItem;
import com.talhanation.smallships.world.item.ModItems;
import com.talhanation.smallships.world.item.SailItem;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModItemsImpl {
    private static final Map<String, RegistryObject<Item>> entries = new HashMap<String, RegistryObject<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"smallships");

    public static Item getItem(String id) {
        return (Item)entries.get(id).get();
    }

    private static void register(String id, Supplier<Item> itemSupplier) {
        entries.put(id, (RegistryObject<Item>)ITEMS.register(id, itemSupplier));
    }

    static {
        boolean hasCustomItemGroup = (Boolean)((CommentedConfig)TomlFormat.instance().createParser().parse(Path.of("config", "smallships-client.toml"), (file, configFormat) -> false)).getOrElse(Arrays.asList("General", "smallshipsItemGroupEnable"), () -> false);
        CreativeModeTab CUSTOM_ITEM_GROUP = hasCustomItemGroup ? new CreativeModeTab("smallships.smallships"){

            @NotNull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModItems.CANNON);
            }
        } : null;
        ModItemsImpl.register("sail", () -> new SailItem(new Item.Properties().m_41487_(16).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40753_)));
        ModItemsImpl.register("cannon", () -> new CannonItem(new Item.Properties().m_41487_(1).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40757_)));
        ModItemsImpl.register("cannon_ball", () -> new CannonBallItem(new Item.Properties().m_41487_(16).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40757_)));
        for (Boat.Type type : Boat.Type.values()) {
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_cog", () -> new CogItem(type, new Item.Properties().m_41487_(1).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40752_)));
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_brigg", () -> new BriggItem(type, new Item.Properties().m_41487_(1).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40752_)));
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_galley", () -> new GalleyItem(type, new Item.Properties().m_41487_(1).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40752_)));
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_drakkar", () -> new DrakkarItem(type, new Item.Properties().m_41487_(1).m_41491_(CUSTOM_ITEM_GROUP != null ? CUSTOM_ITEM_GROUP : CreativeModeTab.f_40752_)));
        }
    }
}

