/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import me.edoren.skin_changer.common.NetworkContext;
import me.edoren.skin_changer.common.NetworkUtils;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.common.messages.PlayerSkinUpdateMessage;
import me.edoren.skin_changer.common.models.PlayerModel;
import me.edoren.skin_changer.common.models.PlayerSkinModel;
import me.edoren.skin_changer.server.providers.ISkinProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;

public class SkinProviderController {
    private static SkinProviderController singleInstance = null;
    private String cacheFile;
    private final Map<DataType, List<ISkinProvider>> providers = new HashMap<DataType, List<ISkinProvider>>();
    private final Map<DataType, Map<PlayerModel, byte[]>> loadedData = new HashMap<DataType, Map<PlayerModel, byte[]>>();
    private final Map<DataType, String> cacheFolders = new HashMap<DataType, String>();

    public static SkinProviderController GetInstance() {
        if (singleInstance == null) {
            singleInstance = new SkinProviderController();
        }
        return singleInstance;
    }

    private SkinProviderController() {
        this.providers.put(DataType.SKIN, new ArrayList());
        this.providers.put(DataType.CAPE, new ArrayList());
        this.loadedData.put(DataType.SKIN, new HashMap());
        this.loadedData.put(DataType.CAPE, new HashMap());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setSaveFolder(File saveFolder) {
        File skinsDir = new File(saveFolder, DataType.SKIN + "s");
        File capesDir = new File(saveFolder, DataType.CAPE + "s");
        skinsDir.mkdirs();
        capesDir.mkdirs();
        this.cacheFolders.put(DataType.SKIN, skinsDir.getPath());
        this.cacheFolders.put(DataType.CAPE, capesDir.getPath());
        File cacheFile = new File(saveFolder, "cache.json");
        try {
            cacheFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.cacheFile = cacheFile.getPath();
    }

    public void clearCapeProviders() {
        this.providers.get((Object)DataType.CAPE).clear();
    }

    public void clearSkinProviders() {
        this.providers.get((Object)DataType.SKIN).clear();
    }

    public void registerCapeProvider(ISkinProvider provider) {
        this.providers.get((Object)DataType.CAPE).add(provider);
    }

    public void registerSkinProvider(ISkinProvider provider) {
        this.providers.get((Object)DataType.SKIN).add(provider);
    }

    public boolean getPlayerSkin(GameProfile profile, ServerPlayer requestingPlayer) {
        PlayerModel model = new PlayerModel(profile);
        if (this.loadedData.get((Object)DataType.SKIN).containsKey(model) || this.loadPlayerDataFromCache(model, DataType.SKIN)) {
            this.sendDataToTarget(model, requestingPlayer);
            return true;
        }
        return false;
    }

    public boolean setPlayerSkinByName(GameProfile profile, String playerName, boolean cache) {
        return this.setPlayerDataByName(new PlayerModel(profile), playerName, cache, DataType.SKIN);
    }

    public boolean setPlayerSkinByURL(GameProfile profile, URL url, boolean cache) {
        return this.setPlayerDataByURL(new PlayerModel(profile), url, cache, DataType.SKIN);
    }

    public boolean setPlayerCapeByName(GameProfile profile, String playerName, boolean cache) {
        return this.setPlayerDataByName(new PlayerModel(profile), playerName, cache, DataType.CAPE);
    }

    public boolean setPlayerCapeByURL(GameProfile profile, URL url, boolean cache) {
        return this.setPlayerDataByURL(new PlayerModel(profile), url, cache, DataType.CAPE);
    }

    private boolean setPlayerDataByName(PlayerModel model, String playerName, boolean cache, DataType dataType) {
        for (ISkinProvider provider : this.providers.get((Object)dataType)) {
            byte[] data = provider.getSkin(playerName);
            if (data == null) continue;
            return this.storePlayerData(model, data, cache, dataType);
        }
        return false;
    }

    private boolean setPlayerDataByURL(PlayerModel model, URL url, boolean cache, DataType dataType) {
        byte[] data = NetworkUtils.downloadFile(url.toString(), null, 2);
        return this.storePlayerData(model, data, cache, dataType);
    }

    public void cleanPlayerSkin(GameProfile profile) {
        this.cleanPlayerData(new PlayerModel(profile), DataType.SKIN);
    }

    public void cleanPlayerCape(GameProfile profile) {
        this.cleanPlayerData(new PlayerModel(profile), DataType.CAPE);
    }

    private void cleanPlayerData(PlayerModel model, DataType dataType) {
        this.deletePlayerDataFromCache(model, dataType);
        if (this.loadedData.get((Object)dataType).containsKey(model)) {
            this.loadedData.get((Object)dataType).remove(model);
            this.sendPlayerDataToAll(model);
        }
    }

    private boolean storePlayerData(PlayerModel model, byte[] data, boolean cache, DataType dataType) {
        if (data == null) {
            return false;
        }
        this.loadedData.get((Object)dataType).put(model, data);
        if (cache) {
            this.savePlayerDataToCache(dataType, model, data);
        }
        this.sendPlayerDataToAll(model);
        LogManager.getLogger().info("Loaded {} for player {}", (Object)dataType, (Object)model);
        return true;
    }

    private void sendDataToTarget(PlayerModel profile, ServerPlayer target) {
        Vector<PlayerSkinModel> playerSkinData = new Vector<PlayerSkinModel>();
        playerSkinData.add(this.getPlayerSkinData(profile));
        PlayerSkinUpdateMessage message = new PlayerSkinUpdateMessage(playerSkinData);
        NetworkContext.GetInstance().getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> target), (Object)message);
    }

    private void sendAllDataToTarget(ServerPlayer target) {
        Vector<PlayerSkinModel> playerSkinData = new Vector<PlayerSkinModel>();
        HashSet<PlayerModel> set = new HashSet<PlayerModel>();
        set.addAll(this.loadedData.get((Object)DataType.SKIN).keySet());
        set.addAll(this.loadedData.get((Object)DataType.CAPE).keySet());
        set.forEach(model -> playerSkinData.add(this.getPlayerSkinData((PlayerModel)model)));
        PlayerSkinUpdateMessage message = new PlayerSkinUpdateMessage(playerSkinData);
        NetworkContext.GetInstance().getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> target), (Object)message);
    }

    private void sendPlayerDataToAll(PlayerModel profile) {
        Vector<PlayerSkinModel> playerSkinData = new Vector<PlayerSkinModel>();
        playerSkinData.add(this.getPlayerSkinData(profile));
        PlayerSkinUpdateMessage message = new PlayerSkinUpdateMessage(playerSkinData);
        NetworkContext.GetInstance().getSimpleChannel().send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    private PlayerSkinModel getPlayerSkinData(PlayerModel profile) {
        byte[] skin = this.loadedData.get((Object)DataType.SKIN).get(profile);
        byte[] cape = this.loadedData.get((Object)DataType.CAPE).get(profile);
        return new PlayerSkinModel(profile, skin, cape);
    }

    private void savePlayerDataToCache(DataType dataType, PlayerModel model, byte[] bytes) {
        SharedPool.execute(() -> {
            try {
                String fileUUID = model.getId();
                List<PlayerModel> playerModels = this.readCacheFile();
                if (playerModels.contains(model)) {
                    for (PlayerModel playerModel : playerModels) {
                        if (!playerModel.equals(model)) continue;
                        fileUUID = playerModel.getId();
                        break;
                    }
                } else {
                    playerModels.add(model);
                }
                this.writeCacheFile(playerModels);
                Path filePath = Paths.get(this.cacheFolders.get((Object)dataType), fileUUID);
                Files.write(filePath, bytes, new OpenOption[0]);
                LogManager.getLogger().info("Caching file {}", (Object)filePath.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private boolean loadPlayerDataFromCache(PlayerModel model, DataType dataType) {
        try {
            List<PlayerModel> playerModels = this.readCacheFile();
            for (PlayerModel playerModel : playerModels) {
                if (!playerModel.equals(model)) continue;
                File file = new File(this.cacheFolders.get((Object)dataType), playerModel.getId());
                if (!file.isFile()) break;
                byte[] data = Files.readAllBytes(file.toPath());
                this.loadedData.get((Object)dataType).put(playerModel, data);
                LogManager.getLogger().info("Loading local {} for player {}", (Object)dataType, (Object)playerModel);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void deletePlayerDataFromCache(PlayerModel model, DataType dataType) {
        SharedPool.execute(() -> {
            try {
                List<PlayerModel> playerModels = this.readCacheFile();
                for (int i = 0; i < playerModels.size(); ++i) {
                    File fileToRemove;
                    PlayerModel playerModel = playerModels.get(i);
                    if (!model.equals(playerModel)) continue;
                    File dataFileSkin = new File(this.cacheFolders.get((Object)DataType.SKIN), playerModel.getId());
                    File dataFileCape = new File(this.cacheFolders.get((Object)DataType.CAPE), playerModel.getId());
                    File file = fileToRemove = dataType.equals((Object)DataType.SKIN) ? dataFileSkin : dataFileCape;
                    if (fileToRemove.isFile() && fileToRemove.delete()) {
                        LogManager.getLogger().info("Removing {} for player {}", (Object)dataType, (Object)model);
                    }
                    if (!dataFileSkin.isFile() && !dataFileSkin.isFile()) {
                        playerModels.remove(i);
                        this.writeCacheFile(playerModels);
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private List<PlayerModel> readCacheFile() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileReader fr = new FileReader(this.cacheFile);
        PlayerModel[] playerModels = (PlayerModel[])gson.fromJson((Reader)fr, PlayerModel[].class);
        fr.close();
        return playerModels != null ? new ArrayList<PlayerModel>(Arrays.asList(playerModels)) : new ArrayList();
    }

    private void writeCacheFile(List<PlayerModel> playersCache) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        FileWriter fw = new FileWriter(this.cacheFile);
        gson.toJson(playersCache, (Appendable)fw);
        fw.close();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        GameProfile profile = event.getEntity().m_36316_();
        LogManager.getLogger().info("Player {} just logged in with id {}", (Object)profile.getName(), (Object)profile.getId());
        SharedPool.get().execute(() -> {
            this.sendAllDataToTarget(player);
            PlayerModel model = new PlayerModel(profile);
            boolean skinLoaded = this.loadPlayerDataFromCache(model, DataType.SKIN);
            boolean capeLoaded = this.loadPlayerDataFromCache(model, DataType.CAPE);
            if (!skinLoaded) {
                skinLoaded = this.setPlayerSkinByName(profile, profile.getName(), true);
            }
            if (!capeLoaded) {
                capeLoaded = this.setPlayerCapeByName(profile, profile.getName(), true);
            }
            if (skinLoaded || capeLoaded) {
                this.sendPlayerDataToAll(model);
            }
        });
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        GameProfile profile = event.getEntity().m_36316_();
        PlayerModel model = new PlayerModel(profile);
        if (this.loadedData.get((Object)DataType.SKIN).containsKey(model) || this.loadedData.get((Object)DataType.CAPE).containsKey(model)) {
            LogManager.getLogger().info("Removing session data for player {}[{}]", (Object)profile.getName(), (Object)profile.getId());
            this.loadedData.get((Object)DataType.SKIN).remove(model);
            this.loadedData.get((Object)DataType.CAPE).remove(model);
            this.sendPlayerDataToAll(model);
        }
    }

    static enum DataType {
        SKIN("skin"),
        CAPE("cape");

        private final String internal;

        private DataType(String envUrl) {
            this.internal = envUrl;
        }

        public String toString() {
            return this.internal;
        }
    }
}

