/*
 * Decompiled with CFR 0.152.
 */
package me.edoren.skin_changer.client.api;

import java.util.HashMap;
import java.util.Map;
import me.edoren.skin_changer.client.ImageUtils;
import me.edoren.skin_changer.client.api.ISkin;
import me.edoren.skin_changer.client.api.SkinData;
import me.edoren.skin_changer.common.NetworkContext;
import me.edoren.skin_changer.common.SharedPool;
import me.edoren.skin_changer.common.messages.PlayerSkinRequestMessage;
import me.edoren.skin_changer.common.models.PlayerModel;
import org.apache.logging.log4j.LogManager;

public class SkinLoaderService {
    private static SkinLoaderService singleInstance = null;
    private final Map<PlayerModel, Object> playerSkinRequests = new HashMap<PlayerModel, Object>();
    private final Map<PlayerModel, ISkin> loadedSkins = new HashMap<PlayerModel, ISkin>();
    private final Map<PlayerModel, ISkin> loadedCapes = new HashMap<PlayerModel, ISkin>();

    public static SkinLoaderService GetInstance() {
        if (singleInstance == null) {
            singleInstance = new SkinLoaderService();
        }
        return singleInstance;
    }

    private SkinLoaderService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlayerSkin(PlayerModel model, byte[] data) {
        if (data == null) {
            this.loadedSkins.remove(model);
            return;
        }
        LogManager.getLogger().info("Loading skin for player {}", (Object)model);
        if (ImageUtils.isNotValidData(data)) {
            LogManager.getLogger().info("Error loading skin for player {}", (Object)model);
            return;
        }
        SkinData skin = new SkinData();
        skin.setSkinFilter(ImageUtils::legacyFilter);
        skin.put(data, ImageUtils.judgeSkinType(data));
        this.loadedSkins.put(model, skin);
        if (this.playerSkinRequests.containsKey(model)) {
            Object object = this.playerSkinRequests.get(model);
            synchronized (object) {
                this.playerSkinRequests.get(model).notify();
            }
        }
    }

    public void loadPlayerCape(PlayerModel model, byte[] data) {
        if (data == null) {
            this.loadedCapes.remove(model);
            return;
        }
        LogManager.getLogger().info("Loading cape for player {}", (Object)model);
        if (ImageUtils.isNotValidData(data)) {
            LogManager.getLogger().info("Error loading cape for player {}", (Object)model);
            return;
        }
        SkinData skin = new SkinData();
        skin.put(data, ImageUtils.judgeSkinType(data));
        this.loadedCapes.put(model, skin);
    }

    public void requestPlayerSkin(PlayerModel model) {
        if (this.loadedSkins.containsKey(model) || this.playerSkinRequests.containsKey(model)) {
            return;
        }
        LogManager.getLogger().info("Requesting skin for player {}", (Object)model);
        Object signal = new Object();
        this.playerSkinRequests.put(model, signal);
        SharedPool.execute(() -> {
            PlayerSkinRequestMessage message = new PlayerSkinRequestMessage(model);
            NetworkContext.GetInstance().getSimpleChannel().sendToServer((Object)message);
            Object object = signal;
            synchronized (object) {
                try {
                    signal.wait(5000L);
                }
                catch (InterruptedException e) {
                    LogManager.getLogger().info("Error loading skin for player {}", (Object)model);
                }
                this.playerSkinRequests.remove(model);
            }
        });
    }

    public ISkin getSkin(PlayerModel model) {
        if (model == null || model.getId() == null) {
            return null;
        }
        return this.loadedSkins.get(model);
    }

    public ISkin getCape(PlayerModel model) {
        if (model == null || model.getId() == null) {
            return null;
        }
        return this.loadedCapes.get(model);
    }

    public void clear() {
        this.loadedSkins.clear();
        this.loadedCapes.clear();
    }
}

