/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block.entity;

import net.hexnowloading.hexfortress.block.property.ChestState;
import net.hexnowloading.hexfortress.registry.HFBlockEntities;
import net.hexnowloading.hexfortress.registry.HFProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.easing.EasingType;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DungeonChestBlockEntity
extends RandomizableContainerBlockEntity
implements MenuProvider,
IAnimatable {
    public static final EnumProperty<ChestState> CHEST_STATE = HFProperties.CHEST_STATE;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandlerModifiable> chestHandler;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            DungeonChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            DungeonChestBlockEntity.playSound(level, pos, state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            DungeonChestBlockEntity.this.signalOpenCount(level, pos, state, oldViewerCount, newViewerCount);
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == DungeonChestBlockEntity.this;
            }
            return false;
        }
    };
    public static final AnimationBuilder CLOSED = new AnimationBuilder().addAnimation("closed", Boolean.valueOf(false));
    public static final AnimationBuilder OPENED = new AnimationBuilder().addAnimation("opened", Boolean.valueOf(false));
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public DungeonChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HFBlockEntities.DUNGEON_CHEST.get(), pos, state);
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.hexfortress.dungeon_chest");
    }

    @Nullable
    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && this.chestHandler == null) {
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag nbt) {
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        }
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        Block block = state.m_60734_();
        level.m_7696_(pos, block, 1, newViewerCount);
        if (oldViewerCount != newViewerCount) {
            if (newViewerCount > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_(HFProperties.CHEST_STATE, (Comparable)((Object)ChestState.OPENED)), 3);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_(HFProperties.CHEST_STATE, (Comparable)((Object)ChestState.CLOSED)), 3);
            }
        }
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 0.5;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_6263_((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public ChestState getChestState() {
        return (ChestState)((Object)this.m_58900_().m_61143_(CHEST_STATE));
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 7.0f, animationEvent -> {
            switch (this.getChestState()) {
                case CLOSED: {
                    animationEvent.getController().easingType = EasingType.EaseOutSine;
                    animationEvent.getController().setAnimation(CLOSED);
                    break;
                }
                case OPENED: {
                    animationEvent.getController().easingType = EasingType.Linear;
                    animationEvent.getController().setAnimation(OPENED);
                    break;
                }
            }
            return PlayState.CONTINUE;
        });
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

