/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.hexnowloading.hexfortress.block.entity.WildfireAlterBlockEntity;
import net.hexnowloading.hexfortress.registry.HFBlockEntities;
import net.hexnowloading.hexfortress.registry.HFItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WildfireAlterBlock
extends BaseEntityBlock {
    public static final int MIN_CHARGES = 0;
    public static final int MAX_CHARGES = 4;
    public static final IntegerProperty CHARGE = BlockStateProperties.f_61389_;
    private static final ImmutableList<Vec3i> RESPAWN_HORIZONTAL_OFFSETS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> RESPAWN_OFFSETS = new ImmutableList.Builder().addAll(RESPAWN_HORIZONTAL_OFFSETS).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7495_).iterator()).addAll(RESPAWN_HORIZONTAL_OFFSETS.stream().map(Vec3i::m_7494_).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public WildfireAlterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CHARGE, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.MAIN_HAND && !WildfireAlterBlock.isRespawnFuel(itemstack) && WildfireAlterBlock.isRespawnFuel(player.m_21120_(InteractionHand.OFF_HAND))) {
            return InteractionResult.PASS;
        }
        if (WildfireAlterBlock.isRespawnFuel(itemstack) && WildfireAlterBlock.canBeCharged(blockState)) {
            WildfireAlterBlock.charge(level, blockPos, blockState);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if ((Integer)blockState.m_61143_((Property)CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (!WildfireAlterBlock.canSetSpawn(level)) {
            if (!level.f_46443_) {
                this.explode(blockState, level, blockPos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!level.f_46443_) {
            return InteractionResult.PASS;
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isRespawnFuel(ItemStack p_55849_) {
        return p_55849_.m_150930_((Item)HFItems.BLAZE_KEY.get());
    }

    private static boolean canBeCharged(BlockState p_55895_) {
        return (Integer)p_55895_.m_61143_((Property)CHARGE) < 4;
    }

    private static boolean isWaterThatWouldFlow(BlockPos p_55888_, Level p_55889_) {
        FluidState fluidstate = p_55889_.m_6425_(p_55888_);
        if (!fluidstate.m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (fluidstate.m_76170_()) {
            return true;
        }
        float f = fluidstate.m_76186_();
        if (f < 2.0f) {
            return false;
        }
        FluidState fluidstate1 = p_55889_.m_6425_(p_55888_.m_7495_());
        return !fluidstate1.m_205070_(FluidTags.f_13131_);
    }

    private void explode(BlockState p_55891_, Level p_55892_, final BlockPos p_55893_) {
        p_55892_.m_7471_(p_55893_, false);
        boolean flag = Direction.Plane.HORIZONTAL.m_122557_().map(arg_0 -> ((BlockPos)p_55893_).m_121945_(arg_0)).anyMatch(p_55854_ -> WildfireAlterBlock.isWaterThatWouldFlow(p_55854_, p_55892_));
        final boolean flag1 = flag || p_55892_.m_6425_(p_55893_.m_7494_()).m_205070_(FluidTags.f_13131_);
        ExplosionDamageCalculator explosiondamagecalculator = new ExplosionDamageCalculator(){

            @NotNull
            public Optional<Float> m_6617_(Explosion p_55904_, BlockGetter p_55905_, @NotNull BlockPos p_55906_, BlockState p_55907_, FluidState p_55908_) {
                return p_55906_.equals((Object)p_55893_) && flag1 ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : super.m_6617_(p_55904_, p_55905_, p_55906_, p_55907_, p_55908_);
            }
        };
        p_55892_.m_7703_((Entity)null, DamageSource.m_19334_(), explosiondamagecalculator, (double)p_55893_.m_123341_() + 0.5, (double)p_55893_.m_123342_() + 0.5, (double)p_55893_.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
    }

    public static boolean canSetSpawn(Level p_55851_) {
        return p_55851_.m_6042_().f_63863_();
    }

    public static void charge(Level level, BlockPos blockPos, BlockState blockState) {
        level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CHARGE, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)CHARGE) + 1)), 3);
        level.m_6263_((Player)null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void m_214162_(@NotNull BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if ((Integer)blockState.m_61143_((Property)CHARGE) != 0) {
            if (randomSource.m_188503_(100) == 0) {
                level.m_6263_((Player)null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            double d0 = (double)blockPos.m_123341_() + 0.5 + (0.5 - randomSource.m_188500_());
            double d1 = (double)blockPos.m_123342_() + 1.0;
            double d2 = (double)blockPos.m_123343_() + 0.5 + (0.5 - randomSource.m_188500_());
            double d3 = (double)randomSource.m_188501_() * 0.04;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123789_, d0, d1, d2, 0.0, d3, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55886_) {
        p_55886_.m_61104_(new Property[]{CHARGE});
    }

    public boolean m_7278_(BlockState p_55860_) {
        return true;
    }

    public static int getScaledChargeLevel(BlockState p_55862_, int p_55863_) {
        return Mth.m_14143_((float)((float)((Integer)p_55862_.m_61143_((Property)CHARGE) - 0) / 4.0f * (float)p_55863_));
    }

    public int m_6782_(BlockState p_55870_, Level p_55871_, BlockPos p_55872_) {
        return WildfireAlterBlock.getScaledChargeLevel(p_55870_, 15);
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> p_55840_, CollisionGetter p_55841_, BlockPos p_55842_) {
        Optional<Vec3> optional = WildfireAlterBlock.findStandUpPosition(p_55840_, p_55841_, p_55842_, true);
        return optional.isPresent() ? optional : WildfireAlterBlock.findStandUpPosition(p_55840_, p_55841_, p_55842_, false);
    }

    private static Optional<Vec3> findStandUpPosition(EntityType<?> p_55844_, CollisionGetter p_55845_, BlockPos p_55846_, boolean p_55847_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : RESPAWN_OFFSETS) {
            blockpos$mutableblockpos.m_122190_((Vec3i)p_55846_).m_122193_(vec3i);
            Vec3 vec3 = DismountHelper.m_38441_(p_55844_, (CollisionGetter)p_55845_, (BlockPos)blockpos$mutableblockpos, (boolean)p_55847_);
            if (vec3 == null) continue;
            return Optional.of(vec3);
        }
        return Optional.empty();
    }

    public boolean m_7357_(BlockState p_55865_, BlockGetter p_55866_, BlockPos p_55867_, PathComputationType p_55868_) {
        return false;
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new WildfireAlterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return WildfireAlterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)HFBlockEntities.WILDFIRE_ALTER.get()), WildfireAlterBlockEntity::tick);
    }
}

