/*
 * Decompiled with CFR 0.152.
 */
package net.hexnowloading.hexfortress.block;

import net.hexnowloading.hexfortress.block.entity.DungeonChestBlockEntity;
import net.hexnowloading.hexfortress.block.property.ChestState;
import net.hexnowloading.hexfortress.registry.HFProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class DungeonChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<ChestState> STATE = HFProperties.CHEST_STATE;
    private static final VoxelShape SHAPE_X = Block.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)14.5, (double)14.0, (double)15.0);
    private static final VoxelShape SHAPE_Z = Block.m_49796_((double)1.0, (double)0.0, (double)1.5, (double)15.0, (double)14.0, (double)14.5);

    public DungeonChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_(STATE, (Comparable)((Object)ChestState.CLOSED)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        switch (((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            default: {
                return SHAPE_X;
            }
            case Z: 
        }
        return SHAPE_Z;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, STATE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        FluidState fluidstate = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState state, boolean moved) {
        if (!oldState.m_60713_(state.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(oldState, level, pos, state, moved);
        }
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    public static boolean isChestBlockedByBlock(BlockGetter blockGetter, BlockPos pos) {
        BlockPos blockPos = pos.m_7494_();
        return blockGetter.m_8055_(blockPos).m_60796_(blockGetter, blockPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof DungeonChestBlockEntity) {
                if (DungeonChestBlock.isChestBlockedByBlock((BlockGetter)level, pos)) {
                    return InteractionResult.SUCCESS;
                }
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((DungeonChestBlockEntity)entity), (BlockPos)pos);
                player.m_36246_(this.getOpenChestStat());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DungeonChestBlockEntity(pos, state);
    }
}

