/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures.reanimated_ruins;

import com.legacy.dungeons_plus.registry.DPJigsawTypes;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.dungeons_plus.structures.reanimated_ruins.ReanimatedRuinsType;
import com.legacy.structure_gel.api.block_entity.BlockEntityAccessHelper;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ReanimatedRuinsStructure {

    public static final class Piece
    extends AbstractGelStructurePiece {
        private static final String TYPE_KEY = "type";
        private final ReanimatedRuinsType type;

        public Piece(StructureTemplateManager structureManager, StructurePoolElement poolElement, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds, ReanimatedRuinsType type) {
            super(structureManager, poolElement, pos, groundLevelDelta, rotation, bounds);
            this.type = type;
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super(context, tag);
            this.type = ReanimatedRuinsType.byName(tag.m_128461_(TYPE_KEY));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_(TYPE_KEY, this.type.m_7912_());
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)DPStructures.REANIMATED_RUINS.getPieceType().get();
        }

        public BlockState modifyState(ServerLevelAccessor level, RandomSource rand, BlockPos pos, BlockState original) {
            return this.type.modifierMap.modifiy(original, rand);
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox bounds) {
            if (key.startsWith("chest")) {
                this.setAir((LevelAccessor)level, pos);
                if (rand.m_188501_() < 0.6f || key.contains("always")) {
                    ResourceLocation loot;
                    loot = rand.m_188501_() < 0.5f ? (loot = this.type.loot) : DPLoot.ReanimatedRuins.CHEST_COMMON;
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)loot);
                } else {
                    this.setAir((LevelAccessor)level, pos.m_7495_());
                }
            }
            if (key.startsWith("spawner")) {
                this.setAir((LevelAccessor)level, pos);
                if (rand.m_188501_() < 0.6f || key.contains("always")) {
                    BlockEntityAccessHelper.placeDynamicSpawner((ServerLevelAccessor)level, (BlockPos)pos, (DynamicSpawnerType)this.type.spawner);
                }
            }
            if (key.equals("decor")) {
                this.setAir((LevelAccessor)level, pos);
                this.type.decorate(level, pos, rand);
            }
        }
    }

    public record Capability(ReanimatedRuinsType type) implements JigsawCapability.IJigsawCapability
    {
        public static final Codec<Capability> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ReanimatedRuinsType.CODEC.fieldOf("ruins_type").forGetter(cap -> cap.type)).apply((Applicative)instance, Capability::new));

        public JigsawCapability.JigsawType<?> getType() {
            return DPJigsawTypes.REANIMATED_RUINS;
        }

        public ExtendedJigsawStructure.IPieceFactory getPieceFactory() {
            return (structureManager, poolElement, pos, ground, rotation, bounds) -> new Piece(structureManager, poolElement, pos, ground, rotation, bounds, this.type);
        }

        public void modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, Structure.GenerationContext context) {
            List pieces = IPieceBuilderModifier.getPieces((StructurePiecesBuilder)pieceBuilder);
            pieces.removeIf(p -> {
                BoundingBox bounds = p.m_73547_();
                int minX = bounds.m_162395_();
                int maxY = bounds.m_162400_();
                int minZ = bounds.m_162401_();
                return maxY > context.f_226622_().m_214096_(minX, minZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()) - 8;
            });
        }
    }
}

