/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus;

import com.legacy.dungeons_plus.data.DPTags;
import com.legacy.dungeons_plus.structures.reanimated_ruins.ReanimatedRuinsType;
import com.legacy.structure_gel.api.config.ConfigBuilder;
import com.legacy.structure_gel.api.config.ConfigValueWrapper;
import com.legacy.structure_gel.api.config.StructureConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class DPConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    private static double toPercent(int i) {
        return (double)i / 100.0;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final StructureConfig tower;
        public final StructureConfig leviathan;
        public final StructureConfig snowyTemple;
        public final StructureConfig reanimatedRuins;
        public final StructureConfig warpedGarden;
        public final StructureConfig soulPrison;
        public final StructureConfig endRuins;
        public final ConfigValueWrapper<Integer, Double> huskLeviathanBladeChance;
        public final ForgeConfigSpec.BooleanValue husksDropSand;
        public final ConfigValueWrapper<Integer, Double> strayFrostedCowlChance;
        public final ForgeConfigSpec.BooleanValue straysDropIce;
        public final ConfigValueWrapper<Integer, Double> drownedWarpedAxeChance;
        public final ConfigValueWrapper<Integer, Double> drownedCoralChance;
        public final ConfigValueWrapper<Integer, Double> skeletonSoulCannonChance;
        public final ForgeConfigSpec.BooleanValue loyaltyReturnsFromVoid;
        public final ForgeConfigSpec.BooleanValue soulCannonProducesFire;
        public final ConfigValueWrapper<Integer, Double> towerWaystoneChance;

        protected Common(ForgeConfigSpec.Builder builder) {
            builder.push("Structures");
            this.tower = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"tower").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_TOWER).popStructure().build();
            this.leviathan = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"leviathan").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_LEVIATHAN).popStructure().build();
            this.snowyTemple = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"snowy_temple").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_SNOWY_TEMPLE).popStructure().build();
            this.reanimatedRuins = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"reanimated_ruins").pushPlacement().probability(75).popPlacement().pushStructure(ReanimatedRuinsType.MOSSY.toString()).biomes(DPTags.Biomes.HAS_REANIMATED_RUINS_MOSSY).popStructure().pushStructure(ReanimatedRuinsType.MESA.toString()).biomes(DPTags.Biomes.HAS_REANIMATED_RUINS_MESA).popStructure().pushStructure(ReanimatedRuinsType.FROZEN.toString()).biomes(DPTags.Biomes.HAS_REANIMATED_RUINS_FROZEN).popStructure().build();
            this.warpedGarden = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"warped_garden").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_WARPED_GARDEN).popStructure().build();
            this.soulPrison = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"soul_prison").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_SOUL_PRISON).popStructure().build();
            this.endRuins = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"end_ruins").pushPlacement().probability(75).popPlacement().pushStructure().biomes(DPTags.Biomes.HAS_END_RUINS).popStructure().build();
            builder.pop();
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            builder.push("Mobs");
            this.huskLeviathanBladeChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"husk_leviathan_blade_chance", (String)"Percent chance that a Husk will wield a Leviathan Blade in the Leviathan.", (int)5, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            this.husksDropSand = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"husks_drop_sand", (String)"Determines if Husks will drop sand when spawned in the Leviathan.", (boolean)true);
            this.strayFrostedCowlChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"stray_frosted_cowl_chance", (String)"Percent chance that a Stray will wear a Frosted Cowl in the Snowy Temple.", (int)5, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            this.straysDropIce = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"strays_drop_ice", (String)"Determines if Strays will drop ice when spawned in the Snowy Temple.", (boolean)true);
            this.drownedWarpedAxeChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"drowned_warped_axe_chance", (String)"Percent chance that a Drowned will wear a Warped Axe in the Warped Garden.", (int)5, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            this.drownedCoralChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"drowned_coral_chance", (String)"Percent chance that a Drowned will hold coral in the Warped Garden.", (int)30, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            this.skeletonSoulCannonChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"skeleton_soul_cannon_chance", (String)"Percent chance that a Skeleton will wield a Soul Cannon in the Soul Prison.", (int)5, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            builder.pop();
            builder.push("Items");
            this.loyaltyReturnsFromVoid = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"loyalty_returns_from_void", (String)"When true, throwable items with loyalty will return if they enter the void.", (boolean)true);
            this.soulCannonProducesFire = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"soul_cannon_produces_fire", (String)"When true, the fireball from a Soul Cannon enchanted with flame will place fire.", (boolean)true);
            builder.pop();
            builder.push("Mod Compat");
            builder.push("Waystones");
            this.towerWaystoneChance = ConfigValueWrapper.create((ForgeConfigSpec.ConfigValue)ConfigBuilder.makeInt((ForgeConfigSpec.Builder)builder, (String)"tower_waystone_chance", (String)"Percent chance for a waystone from Waystones to generate on top of the tower", (int)100, (int)0, (int)100), DPConfig::toPercent, (IEventBus)bus, (String)"dungeons_plus");
            builder.pop();
            builder.pop();
        }
    }
}

