/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.structures.DEDeepCrypt;
import com.barion.dungeons_enhanced.world.structures.DEDesertTemple;
import com.barion.dungeons_enhanced.world.structures.DEDesertTomb;
import com.barion.dungeons_enhanced.world.structures.DEEldersTemple;
import com.barion.dungeons_enhanced.world.structures.DEIcePit;
import com.barion.dungeons_enhanced.world.structures.DELargeDungeon;
import com.barion.dungeons_enhanced.world.structures.DEMonsterMaze;
import com.barion.dungeons_enhanced.world.structures.DEPillagerCamp;
import com.barion.dungeons_enhanced.world.structures.DEPirateShip;
import com.barion.dungeons_enhanced.world.structures.prefabs.DECellarStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEFlyingStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DESimpleStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DESwimmingStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEUndergroundStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEUnderwaterStructure;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.ExtendedJigsawStructure;
import com.legacy.structure_gel.api.structure.GridStructurePlacement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class DEStructures {
    public static StructureRegistrar<ExtendedJigsawStructure> Castle;
    public static StructureRegistrar<ExtendedJigsawStructure> DeepCrypt;
    public static StructureRegistrar<DEDesertTemple> DesertTemple;
    public static StructureRegistrar<ExtendedJigsawStructure> DesertTomb;
    public static StructureRegistrar<ExtendedJigsawStructure> DruidCircle;
    public static StructureRegistrar<DEUndergroundStructure> DungeonVariant;
    public static StructureRegistrar<DEEldersTemple> EldersTemple;
    public static StructureRegistrar<DESwimmingStructure> FishingShip;
    public static StructureRegistrar<DEFlyingStructure> FlyingDutchman;
    public static StructureRegistrar<DESimpleStructure> HayStorage;
    public static StructureRegistrar<DEIcePit> IcePit;
    public static StructureRegistrar<DESimpleStructure> JungleMonument;
    public static StructureRegistrar<ExtendedJigsawStructure> LargeDungeon;
    public static StructureRegistrar<DESimpleStructure> MinersHouse;
    public static StructureRegistrar<ExtendedJigsawStructure> MonsterMaze;
    public static StructureRegistrar<DESimpleStructure> MushroomHouse;
    public static StructureRegistrar<ExtendedJigsawStructure> PillagerCamp;
    public static StructureRegistrar<DEPirateShip> PirateShip;
    public static StructureRegistrar<DESimpleStructure> RuinedBuilding;
    public static StructureRegistrar<DESimpleStructure> Stables;
    public static StructureRegistrar<DEUnderwaterStructure> SunkenShrine;
    public static StructureRegistrar<DESimpleStructure> TallWitchHut;
    public static StructureRegistrar<DESimpleStructure> TreeHouse;
    public static StructureRegistrar<DESimpleStructure> TowerOfTheUndead;
    public static StructureRegistrar<DESimpleStructure> WatchTower;
    public static StructureRegistrar<DESimpleStructure> WitchTower;

    private DEStructures() {
    }

    public static StructureRegistrar<?>[] getAllStructureRegistrars() {
        return new StructureRegistrar[]{Castle, DeepCrypt, DesertTemple, DesertTomb, DruidCircle, DungeonVariant, EldersTemple, FishingShip, FlyingDutchman, HayStorage, IcePit, JungleMonument, LargeDungeon, MinersHouse, MonsterMaze, MushroomHouse, PillagerCamp, PirateShip, RuinedBuilding, Stables, SunkenShrine, TallWitchHut, TreeHouse, TowerOfTheUndead, WatchTower, WitchTower};
    }

    private static ConstantHeight height(int y) {
        return ConstantHeight.m_161956_((VerticalAnchor)new VerticalAnchor.Absolute(y));
    }

    private static Supplier<List<MobSpawnSettings.SpawnerData>> spawns(MobSpawnSettings.SpawnerData ... spawns) {
        return () -> Arrays.stream(spawns).toList();
    }

    private static MobSpawnSettings.SpawnerData spawn(EntityType<?> entity, int weight, int min, int max) {
        return new MobSpawnSettings.SpawnerData(entity, weight, min, max);
    }

    private static <S extends Structure> Supplier<StructureType<S>> codecOf(Function<Structure.StructureSettings, S> constructor) {
        return () -> () -> Structure.m_226607_((Function)constructor);
    }

    public static void init() {
    }

    static {
        DECellarStructure.init();
        Castle = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("castle")).addPiece(() -> DECellarStructure.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DECellarStructure.CastlePool.Root, 1, (HeightProvider)ConstantHeight.f_161945_, false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(Castle.getRegistryName(), DECellarStructure.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.Castle).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.Castle).build(Castle)).build();
        DEDeepCrypt.Pool.init();
        DeepCrypt = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("deep_crypt")).addPiece(() -> DEDeepCrypt.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DEDeepCrypt.Pool.Root, 4, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16)), false).withPieceFactory(DeepCrypt.getRegistryName(), DEDeepCrypt.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.DeepCrypt).getStructure()).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.DeepCrypt).build(DeepCrypt)).build();
        DesertTemple = StructureRegistrar.builder((ResourceLocation)DEUtil.location("desert_temple"), DEStructures.codecOf(DEDesertTemple::new)).addPiece(() -> DEDesertTemple.Piece::new).pushStructure(DEDesertTemple::new).config(() -> ((StructureConfig)DEConfig.COMMON.DesertTemple).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.DesertTemple).build(DesertTemple)).build();
        DEDesertTomb.Pool.init();
        DesertTomb = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("desert_tomb")).addPiece(() -> DEDesertTomb.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DEDesertTomb.Pool.Root, 4, (HeightProvider)ConstantHeight.f_161945_, false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(DesertTomb.getRegistryName(), DEDesertTomb.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.DesertTomb).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.DesertTemple).allowedNearSpawn(true).build(DesertTomb)).build();
        DruidCircle = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("druid_circle")).addPiece(() -> DECellarStructure.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DECellarStructure.DruidCirclePool.Root, 1, (HeightProvider)ConstantHeight.f_161945_, false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(DruidCircle.getRegistryName(), DECellarStructure.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.DruidCircle).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.DruidCircle).allowedNearSpawn(true).build(DruidCircle)).build();
        Function<Structure.StructureSettings, DEUndergroundStructure> dungeonVariant = settings -> new DEUndergroundStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-6, 0, -6).add("dungeon_variant/zombie").add("dungeon_variant/skeleton").add("dungeon_variant/spider").build(), () -> DungeonVariant.getType());
        DungeonVariant = StructureRegistrar.builder((ResourceLocation)DEUtil.location("dungeon_variant"), DEStructures.codecOf(dungeonVariant)).addPiece(() -> DEUndergroundStructure.Piece::new).pushStructure(dungeonVariant).config(() -> ((StructureConfig)DEConfig.COMMON.DungeonVariant).getStructure()).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.DungeonVariant).allowedNearSpawn(true).build(DungeonVariant)).build();
        EldersTemple = StructureRegistrar.builder((ResourceLocation)DEUtil.location("elders_temple"), DEStructures.codecOf(DEEldersTemple::new)).addPiece(() -> DEEldersTemple.Piece::new).pushStructure(DEEldersTemple::new).config(() -> ((StructureConfig)DEConfig.COMMON.EldersTemple).getStructure()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20455_, 1, 2, 4))).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.EldersTemple).build(EldersTemple)).build();
        Function<Structure.StructureSettings, DESwimmingStructure> fishingShip = settings -> new DESwimmingStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-4, -3, -14).add("fishing_ship").build(), () -> FishingShip.getType());
        FishingShip = StructureRegistrar.builder((ResourceLocation)DEUtil.location("fishing_ship"), DEStructures.codecOf(fishingShip)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(fishingShip).config(() -> ((StructureConfig)DEConfig.COMMON.FishingShip).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.FishingShip).allowedNearSpawn(true).build(FishingShip)).build();
        Function<Structure.StructureSettings, DEFlyingStructure> flyingDutchman = settings -> new DEFlyingStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-4, 0, -15).add("flying_dutchman").build(), () -> FlyingDutchman.getType());
        FlyingDutchman = StructureRegistrar.builder((ResourceLocation)DEUtil.location("flying_dutchman"), DEStructures.codecOf(flyingDutchman)).addPiece(() -> DEFlyingStructure.Piece::new).pushStructure(flyingDutchman).config(() -> ((StructureConfig)DEConfig.COMMON.FlyingDutchman).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.FlyingDutchman).build(FlyingDutchman)).build();
        Function<Structure.StructureSettings, DESimpleStructure> hayStorage = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-7, 0, -7).add("hay_storage/small").offset(-9, 0, -9).add("hay_storage/big").build(), () -> HayStorage.getType());
        HayStorage = StructureRegistrar.builder((ResourceLocation)DEUtil.location("hay_storage"), DEStructures.codecOf(hayStorage)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(hayStorage).config(() -> ((StructureConfig)DEConfig.COMMON.HayStorage).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.HayStorage).allowedNearSpawn(true).build(HayStorage)).build();
        IcePit = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ice_pit"), DEStructures.codecOf(DEIcePit::new)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(DEIcePit::new).config(() -> ((StructureConfig)DEConfig.COMMON.IcePit).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.IcePit).build(IcePit)).build();
        Function<Structure.StructureSettings, DESimpleStructure> jungleMonument = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-12, -9, -12).add("jungle_monument").build(), () -> JungleMonument.getType());
        JungleMonument = StructureRegistrar.builder((ResourceLocation)DEUtil.location("jungle_monument"), DEStructures.codecOf(jungleMonument)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(jungleMonument).config(() -> ((StructureConfig)DEConfig.COMMON.JungleMonument).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.JungleMonument).build(JungleMonument)).build();
        DELargeDungeon.Pool.init();
        LargeDungeon = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("large_dungeon")).addPiece(() -> DELargeDungeon.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DELargeDungeon.Pool.Root, 5, (HeightProvider)DEStructures.height(-16), false, Heightmap.Types.WORLD_SURFACE_WG)).config(() -> ((StructureConfig)DEConfig.COMMON.LargeDungeon).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.LargeDungeon).allowedNearSpawn(true).build(LargeDungeon)).build();
        Function<Structure.StructureSettings, DESimpleStructure> minersHouse = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-5, 0, -5).add("miners_house").build(), () -> MinersHouse.getType());
        MinersHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("miners_house"), DEStructures.codecOf(minersHouse)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(minersHouse).config(() -> ((StructureConfig)DEConfig.COMMON.MinersHouse).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.MinersHouse).allowedNearSpawn(true).build(MinersHouse)).build();
        DEMonsterMaze.Pool.init();
        MonsterMaze = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("monster_maze")).addPiece(() -> DEMonsterMaze.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DEMonsterMaze.Pool.Root, 11, (HeightProvider)DEStructures.height(-17), true, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(MonsterMaze.getRegistryName(), DEMonsterMaze.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.MonsterMaze).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.MonsterMaze).build(MonsterMaze)).build();
        Function<Structure.StructureSettings, DESimpleStructure> mushroomHouse = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-7, 0, -7).add("mushroom_house/red").add("mushroom_house/brown").build(), () -> MushroomHouse.getType());
        MushroomHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("mushroom_house"), DEStructures.codecOf(mushroomHouse)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(mushroomHouse).config(() -> ((StructureConfig)DEConfig.COMMON.MushroomHouse).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.MushroomHouse).allowedNearSpawn(true).build(MushroomHouse)).build();
        DEPillagerCamp.Pool.init();
        PillagerCamp = StructureRegistrar.jigsawBuilder((ResourceLocation)DEUtil.location("pillager_camp")).addPiece(() -> DEPillagerCamp.Piece::new).pushStructure(settings -> new ExtendedJigsawStructure(settings, DEPillagerCamp.Pool.Root, 4, (HeightProvider)ConstantHeight.f_161945_, false, Heightmap.Types.WORLD_SURFACE_WG).withPieceFactory(PillagerCamp.getRegistryName(), DEPillagerCamp.Piece::new)).config(() -> ((StructureConfig)DEConfig.COMMON.PillagerCamp).getStructure()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20513_, 4, 2, 3), DEStructures.spawn(EntityType.f_20493_, 2, 1, 2))).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.PillagerCamp).build(PillagerCamp)).build();
        PirateShip = StructureRegistrar.builder((ResourceLocation)DEUtil.location("pirate_ship"), DEStructures.codecOf(DEPirateShip::new)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(DEPirateShip::new).config(() -> ((StructureConfig)DEConfig.COMMON.PirateShip).getStructure()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, DEStructures.spawns(DEStructures.spawn(EntityType.f_20513_, 4, 3, 4), DEStructures.spawn(EntityType.f_20493_, 3, 1, 2))).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.PirateShip).build(PirateShip)).build();
        Function<Structure.StructureSettings, DESimpleStructure> ruinedBuilding = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-5, 0, -5).weight(3).add("ruined_building/house").offset(-6, 0, -8).weight(2).add("ruined_building/house_big").offset(-4, 0, -5).weight(3).add("ruined_building/barn").build(), () -> RuinedBuilding.getType());
        RuinedBuilding = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ruined_building"), DEStructures.codecOf(ruinedBuilding)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(ruinedBuilding).config(() -> ((StructureConfig)DEConfig.COMMON.RuinedBuilding).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.RuinedBuilding).allowedNearSpawn(true).build(RuinedBuilding)).build();
        Function<Structure.StructureSettings, DESimpleStructure> stables = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-8, -6, -13).add("stables").build(), () -> Stables.getType());
        Stables = StructureRegistrar.builder((ResourceLocation)DEUtil.location("stables"), DEStructures.codecOf(stables)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(stables).config(() -> ((StructureConfig)DEConfig.COMMON.Stables).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.Stables).allowedNearSpawn(true).build(Stables)).build();
        Function<Structure.StructureSettings, DEUnderwaterStructure> sunkenShrine = settings -> new DEUnderwaterStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-5, -1, -8).add("sunken_shrine").build(), () -> SunkenShrine.getType());
        SunkenShrine = StructureRegistrar.builder((ResourceLocation)DEUtil.location("sunken_shrine"), DEStructures.codecOf(sunkenShrine)).addPiece(() -> DEUnderwaterStructure.Piece::new).pushStructure(sunkenShrine).config(() -> ((StructureConfig)DEConfig.COMMON.SunkenShrine).getStructure()).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.SunkenShrine).allowedNearSpawn(true).build(SunkenShrine)).build();
        Function<Structure.StructureSettings, DESimpleStructure> tallWitchHut = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-3, -3, -4).add("tall_witch_hut").build(), () -> TallWitchHut.getType());
        TallWitchHut = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tall_witch_hut"), DEStructures.codecOf(tallWitchHut)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(tallWitchHut).config(() -> ((StructureConfig)DEConfig.COMMON.TallWitchHut).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.TallWitchHut).allowedNearSpawn(true).build(TallWitchHut)).build();
        Function<Structure.StructureSettings, DESimpleStructure> treeHouse = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-11, 0, -12).add("tree_house").build(), () -> TreeHouse.getType());
        TreeHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tree_house"), DEStructures.codecOf(treeHouse)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(treeHouse).config(() -> ((StructureConfig)DEConfig.COMMON.TreeHouse).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.TreeHouse).allowedNearSpawn(true).build(TreeHouse)).build();
        Function<Structure.StructureSettings, DESimpleStructure> undeadTower = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-5, 0, -5).weight(3).add("tower_of_the_undead/small").offset(-7, 0, -7).weight(2).add("tower_of_the_undead/big").build(), () -> TowerOfTheUndead.getType());
        TowerOfTheUndead = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tower_of_the_undead"), DEStructures.codecOf(undeadTower)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(undeadTower).config(() -> ((StructureConfig)DEConfig.COMMON.TowerOfTheUndead).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.TowerOfTheUndead).allowedNearSpawn(true).build(TowerOfTheUndead)).build();
        Function<Structure.StructureSettings, DESimpleStructure> watchTower = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-4, 0, -4).add("watch_tower").build(), () -> WatchTower.getType());
        WatchTower = StructureRegistrar.builder((ResourceLocation)DEUtil.location("watch_tower"), DEStructures.codecOf(watchTower)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(watchTower).config(() -> ((StructureConfig)DEConfig.COMMON.WatchTower).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.WatchTower).allowedNearSpawn(true).build(WatchTower)).build();
        Function<Structure.StructureSettings, DESimpleStructure> witchTower = settings -> new DESimpleStructure((Structure.StructureSettings)settings, DEUtil.pieceBuilder().offset(-6, 0, -5).weight(3).add("witch_tower/normal").offset(-7, 0, -7).weight(2).add("witch_tower/big").build(), () -> WitchTower.getType());
        WitchTower = StructureRegistrar.builder((ResourceLocation)DEUtil.location("witch_tower"), DEStructures.codecOf(witchTower)).addPiece(() -> DESimpleStructure.Piece::new).pushStructure(witchTower).config(() -> ((StructureConfig)DEConfig.COMMON.WitchTower).getStructure()).terrainAdjustment(TerrainAdjustment.BEARD_THIN).popStructure().placement(() -> GridStructurePlacement.builder().config(() -> DEConfig.COMMON.WitchTower).allowedNearSpawn(true).build(WitchTower)).build();
    }
}

