/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.legacy.structure_gel.api.config.StructureConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DEConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        private final ForgeConfigSpec.Builder builder;
        public final StructureConfig Castle;
        public final StructureConfig DeepCrypt;
        public final StructureConfig DesertTemple;
        public final StructureConfig DesertTomb;
        public final StructureConfig DruidCircle;
        public final StructureConfig DungeonVariant;
        public final StructureConfig EldersTemple;
        public final StructureConfig FishingShip;
        public final StructureConfig FlyingDutchman;
        public final StructureConfig HayStorage;
        public final StructureConfig IcePit;
        public final StructureConfig JungleMonument;
        public final StructureConfig LargeDungeon;
        public final StructureConfig MinersHouse;
        public final StructureConfig MonsterMaze;
        public final StructureConfig MushroomHouse;
        public final StructureConfig PillagerCamp;
        public final StructureConfig PirateShip;
        public final StructureConfig RuinedBuilding;
        public final StructureConfig Stables;
        public final StructureConfig SunkenShrine;
        public final StructureConfig TallWitchHut;
        public final StructureConfig TowerOfTheUndead;
        public final StructureConfig TreeHouse;
        public final StructureConfig WatchTower;
        public final StructureConfig WitchTower;

        protected Common(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            this.Castle = this.configs("castle", 56, 42, (ResourceKey<Level>)Level.f_46428_, "#forge:is_cold/overworld", "#forge:is_snowy", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach");
            this.DeepCrypt = this.configs("deep_crypt", 35, 75, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld");
            this.DesertTemple = this.configs("desert_temple", 31, 60, (ResourceKey<Level>)Level.f_46428_, "minecraft:desert");
            this.DesertTomb = this.configs("desert_tomb", 29, 65, (ResourceKey<Level>)Level.f_46428_, "minecraft:desert");
            this.DruidCircle = this.configs("druid_circle", 39, 40, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_cold/overworld", "!#forge:is_hot/overworld", "!#minecraft:is_forest", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach", "!#forge:is_underground");
            this.DungeonVariant = this.configs("dungeon_variant", 16, 80, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld");
            this.EldersTemple = this.configs("elders_temple", 34, 82, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_ocean");
            this.FishingShip = this.configs("fishing_ship", 48, 68, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_ocean");
            this.FlyingDutchman = this.configs("flying_dutchman", 67, 40, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_ocean");
            this.HayStorage = this.configs("hay_storage", 24, 75, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_savanna");
            this.IcePit = this.configs("ice_pit", 35, 70, (ResourceKey<Level>)Level.f_46428_, "#forge:is_snowy", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach");
            this.JungleMonument = this.configs("jungle_monument", 41, 75, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_jungle");
            this.LargeDungeon = this.configs("large_dungeon", 39, 35, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_hot/overworld", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach", "!#forge:is_underground");
            this.MinersHouse = this.configs("miners_mouse", 24, 80, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_badlands");
            this.MonsterMaze = this.configs("monster_maze", 34, 50, (ResourceKey<Level>)Level.f_46428_, "minecraft:dark_forest");
            this.MushroomHouse = this.configs("mushroom_house", 15, 75, (ResourceKey<Level>)Level.f_46428_, "minecraft:mushroom_fields", "minecraft:mushroom_field_shore");
            this.PillagerCamp = this.configs("pillager_camp", 49, 35, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_cold/overworld", "!#forge:is_hot/overworld", "!#minecraft:is_forest", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach", "!#forge:is_underground");
            this.PirateShip = this.configs("pirate_ship", 65, 49, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_ocean");
            this.RuinedBuilding = this.configs("ruined_building", 27, 45, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_hot/overworld", "!#forge:is_water", "!#forge:is_mountain", "!#forge:is_underground");
            this.Stables = this.configs("stables", 46, 32, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_cold/overworld", "!#forge:is_hot/overworld", "!#minecraft:is_forest", "!#forge:is_water", "!#forge:is_mountain", "!#minecraft:is_beach", "!#forge:is_underground");
            this.SunkenShrine = this.configs("sunken_shrine", 32, 55, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_ocean");
            this.TallWitchHut = this.configs("tall_witch_hut", 18, 60, (ResourceKey<Level>)Level.f_46428_, "#forge:is_swamp");
            this.TowerOfTheUndead = this.configs("tower_of_the_undead", 37, 35, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_overworld", "!#forge:is_sandy", "!#forge:is_water", "!#minecraft:is_beach", "!#forge:is_underground");
            this.TreeHouse = this.configs("tree_house", 29, 40, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_jungle");
            this.WatchTower = this.configs("watch_tower", 33, 45, (ResourceKey<Level>)Level.f_46428_, "#forge:is_cold/overworld", "!#forge:is_water");
            this.WitchTower = this.configs("witch_tower", 29, 45, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_taiga");
        }

        private StructureConfig configs(String name, int spacing, int prob, ResourceKey<Level> dimension, String ... biomes) {
            return StructureConfig.builder((ForgeConfigSpec.Builder)this.builder, (String)name).pushPlacement().spacing(spacing).offset((int)((float)spacing / 1.5f)).probability(prob).popPlacement().pushStructure().biomes(biomes).dimensions(new ResourceKey[]{dimension}).popStructure().build();
        }
    }
}

