/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.awesomedungeonnether;

import com.jtorleonstudios.awesomedungeonnether.AwsNetherConfig;
import com.jtorleonstudios.awesomedungeonnether.Main;
import com.jtorleonstudios.libraryferret.worldgen.structures.AwesomeStructure;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

interface AwsNetherStructure {
    public static final Codec<AwesomeDungeonStructure> CODEC = AwesomeDungeonStructure.getDefaultCodec((int)1, (int)2, uniqueResourceLocationStartPool -> AwsNetherConfig.get(uniqueResourceLocationStartPool).isEnabled(), AwesomeDungeonStructure::new);

    public static class AwesomeDungeonStructure
    extends AwesomeStructure {
        int BIOME_RANGE = 1;

        public AwesomeDungeonStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
            super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
        }

        private static List<BlockPos.MutableBlockPos> getPotentialPosition(Structure.GenerationContext ctx) {
            BlockPos centerOfChunk = ctx.f_226628_().m_151394_(0);
            int landHeight = ctx.f_226622_().m_223235_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, ctx.f_226629_(), ctx.f_226624_()) - 50;
            BlockPos.MutableBlockPos bpm = new BlockPos.MutableBlockPos(centerOfChunk.m_123341_(), 0, centerOfChunk.m_123343_());
            NoiseColumn columnOfBlocks = ctx.f_226622_().m_214184_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), ctx.f_226629_(), ctx.f_226624_());
            ArrayList<BlockPos.MutableBlockPos> data = new ArrayList<BlockPos.MutableBlockPos>();
            for (int i = 0; i < landHeight; ++i) {
                BlockState beforeMoveState = columnOfBlocks.m_183556_(bpm.m_123342_());
                boolean beforeMoveIsGround = !beforeMoveState.m_60795_() && beforeMoveState.m_60819_().m_76178_();
                bpm.m_122173_(Direction.UP);
                if (!beforeMoveIsGround || !columnOfBlocks.m_183556_(bpm.m_123342_()).m_60795_()) continue;
                data.add(bpm.m_122032_());
            }
            return data;
        }

        protected boolean canGenerate(Structure.GenerationContext ctx) {
            return !AwesomeDungeonStructure.getPotentialPosition(ctx).isEmpty();
        }

        protected BlockPos getInitialStartPosition(Structure.GenerationContext ctx) {
            List<BlockPos.MutableBlockPos> data = AwesomeDungeonStructure.getPotentialPosition(ctx);
            return (BlockPos)data.get(new Random().nextInt(data.size()));
        }

        @NotNull
        public StructureType<?> m_213658_() {
            return (StructureType)Main.AWS_STRUCTURE_TYPE.get();
        }
    }
}

