/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.zombie_dungeon;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.processor.ISafeWorldModifier;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;

public class ZombieMainStairsProcessor
extends StructureProcessor
implements ISafeWorldModifier {
    public static final ZombieMainStairsProcessor INSTANCE = new ZombieMainStairsProcessor();
    public static final Codec<ZombieMainStairsProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static final BlockStateRandomizer STAIR_SELECTOR = new BlockStateRandomizer(Blocks.f_50157_.m_49966_()).addBlock(Blocks.f_50633_.m_49966_(), 0.4f).addBlock(Blocks.f_50409_.m_49966_(), 0.1f).addBlock(Blocks.f_50647_.m_49966_(), 0.1f).addBlock(Blocks.f_50627_.m_49966_(), 0.1f).addBlock(Blocks.f_50652_.m_49966_(), 0.1f).addBlock(Blocks.f_50079_.m_49966_(), 0.1f);
    private static final BlockStateRandomizer COBBLE_SELECTOR = new BlockStateRandomizer(Blocks.f_50652_.m_49966_()).addBlock(Blocks.f_50079_.m_49966_(), 0.3f);
    private static final Set<Material> REPLACEABLE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.f_76278_, Material.f_76300_, Material.f_76301_, Material.f_76313_, Material.f_76308_, Material.f_76313_, Material.f_76314_, Material.f_76315_, Material.f_76276_, Material.f_76316_, Material.f_76317_, Material.f_76274_, Material.f_76278_, Material.f_76280_, Material.f_164532_});

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_.m_60734_() == Blocks.f_50668_) {
            BlockState lanternBlock;
            int middleSurfaceHeight;
            BlockPos.MutableBlockPos temp = blockInfoGlobal.f_74675_.m_122032_();
            Direction facing = switch (structurePlacementData.m_74404_()) {
                case Rotation.CLOCKWISE_90 -> Direction.EAST;
                case Rotation.COUNTERCLOCKWISE_90 -> Direction.WEST;
                case Rotation.CLOCKWISE_180 -> Direction.SOUTH;
                default -> Direction.NORTH;
            };
            int maxLength = BetterDungeonsCommon.CONFIG.zombieDungeons.zombieDungeonMaxSurfaceStaircaseLength;
            BlockPos maxSurfacePos = blockInfoGlobal.f_74675_.m_5484_(facing, maxLength).m_5484_(Direction.UP, maxLength);
            temp.m_122175_(facing, maxLength);
            int surfaceHeight = levelReader.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, temp.m_123341_(), temp.m_123343_());
            if (surfaceHeight >= maxSurfacePos.m_123342_()) {
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, Blocks.f_50627_.m_49966_(), blockInfoGlobal.f_74677_);
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_);
            BlockPos.MutableBlockPos leftPos = new BlockPos((Vec3i)blockInfoGlobal.f_74675_.m_121945_(facing.m_122428_())).m_122032_();
            BlockPos.MutableBlockPos middlePos = new BlockPos((Vec3i)blockInfoGlobal.f_74675_).m_122032_();
            BlockPos.MutableBlockPos rightPos = new BlockPos((Vec3i)blockInfoGlobal.f_74675_.m_121945_(facing.m_122427_())).m_122032_();
            for (int i = 0; i < maxLength && (middleSurfaceHeight = levelReader.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, middlePos.m_123341_(), middlePos.m_123343_())) >= middlePos.m_123342_(); ++i) {
                int y;
                BlockState tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)leftPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, leftPos.m_121945_(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50652_.m_49966_(), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)middlePos)) {
                    if (this.isMaterialLiquidSafe(levelReader, middlePos.m_121945_(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50652_.m_49966_(), (BlockPos)middlePos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)middlePos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!this.isBlockStateAirSafe(levelReader, (BlockPos)rightPos)) {
                    if (this.isMaterialLiquidSafe(levelReader, rightPos.m_121945_(facing))) {
                        this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50652_.m_49966_(), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    } else {
                        this.setBlockStateSafeWithPlacement(levelReader, tempBlock, (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    }
                }
                for (int y2 = middlePos.m_123342_() + 1; y2 <= middlePos.m_123342_() + 3; ++y2) {
                    temp.m_122178_(leftPos.m_123341_(), y2, leftPos.m_123343_());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50627_.m_49966_(), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    temp.m_122178_(middlePos.m_123341_(), y2, middlePos.m_123343_());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50627_.m_49966_(), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    temp.m_122178_(rightPos.m_123341_(), y2, rightPos.m_123343_());
                    this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50627_.m_49966_(), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                }
                float cobbleChance = (float)(maxLength - i) / (float)maxLength;
                cobbleChance = Math.max(cobbleChance, 0.25f);
                temp.m_122178_(leftPos.m_123341_(), leftPos.m_123342_() + 4, leftPos.m_123343_());
                Optional tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).m_60767_().m_76332_() || random.m_188501_() < cobbleChance && REPLACEABLE_MATERIALS.contains(((BlockState)tempOptional.get()).m_60767_())) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                }
                temp.m_122178_(middlePos.m_123341_(), middlePos.m_123342_() + 4, middlePos.m_123343_());
                tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).m_60767_().m_76332_() || random.m_188501_() < cobbleChance && REPLACEABLE_MATERIALS.contains(((BlockState)tempOptional.get()).m_60767_())) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                }
                temp.m_122178_(rightPos.m_123341_(), rightPos.m_123342_() + 4, rightPos.m_123343_());
                tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).m_60767_().m_76332_() || random.m_188501_() < cobbleChance && REPLACEABLE_MATERIALS.contains(((BlockState)tempOptional.get()).m_60767_())) {
                    this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                }
                temp.m_122190_((Vec3i)leftPos.m_121945_(facing.m_122428_()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                    if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).m_60767_().m_76332_() || random.m_188501_() < cobbleChance && REPLACEABLE_MATERIALS.contains(((BlockState)tempOptional.get()).m_60767_())) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    }
                    temp.m_122173_(Direction.UP);
                }
                temp.m_122190_((Vec3i)rightPos.m_121945_(facing.m_122427_()));
                for (y = 0; y <= 4; ++y) {
                    tempOptional = this.getBlockStateSafe(levelReader, (BlockPos)temp);
                    if (tempOptional.isEmpty() || ((BlockState)tempOptional.get()).m_60767_().m_76332_() || random.m_188501_() < cobbleChance && REPLACEABLE_MATERIALS.contains(((BlockState)tempOptional.get()).m_60767_())) {
                        this.setBlockStateSafeWithPlacement(levelReader, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
                    }
                    temp.m_122173_(Direction.UP);
                }
                leftPos.m_122173_(facing).m_122173_(Direction.UP);
                middlePos.m_122173_(facing).m_122173_(Direction.UP);
                rightPos.m_122173_(facing).m_122173_(Direction.UP);
            }
            leftPos.m_122173_(facing.m_122424_()).m_122173_(Direction.DOWN);
            middlePos.m_122173_(facing.m_122424_()).m_122173_(Direction.DOWN);
            rightPos.m_122173_(facing.m_122424_()).m_122173_(Direction.DOWN);
            BlockStateRandomizer tombSelector = new BlockStateRandomizer(Blocks.f_50652_.m_49966_()).addBlock(Blocks.f_50079_.m_49966_(), 0.4f);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50405_.m_49966_(), leftPos.m_5484_(Direction.UP, 2), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50405_.m_49966_(), middlePos.m_5484_(Direction.UP, 2), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50405_.m_49966_(), rightPos.m_5484_(Direction.UP, 2), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50470_.m_49966_(), leftPos.m_5484_(Direction.UP, 3), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50470_.m_49966_(), middlePos.m_5484_(Direction.UP, 3), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50470_.m_49966_(), rightPos.m_5484_(Direction.UP, 3), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            BlockState blockState = lanternBlock = BetterDungeonsCommon.CONFIG.general.enableNetherBlocks ? (BlockState)Blocks.f_50682_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true)) : (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true));
            if (random.m_188501_() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, leftPos.m_5484_(Direction.UP, 1), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            } else if (random.m_188501_() < 0.25f) {
                this.setBlockStateSafeWithPlacement(levelReader, lanternBlock, rightPos.m_5484_(Direction.UP, 1), structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            }
            leftPos.m_122173_(facing.m_122428_());
            rightPos.m_122173_(facing.m_122427_());
            this.setColumn(levelReader, tombSelector, leftPos.m_121945_(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.m_121945_(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50387_.m_49966_(), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50387_.m_49966_(), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50387_.m_49966_(), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50387_.m_49966_(), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50470_.m_49966_(), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, Blocks.f_50470_.m_49966_(), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateRandom(levelReader, Blocks.f_50470_.m_49966_(), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            this.setBlockStateRandom(levelReader, Blocks.f_50470_.m_49966_(), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            leftPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            rightPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            this.setColumn(levelReader, tombSelector, leftPos.m_121945_(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.m_121945_(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            leftPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            rightPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            this.setColumn(levelReader, tombSelector, leftPos.m_121945_(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.m_121945_(Direction.DOWN), random);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            leftPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            rightPos.m_122173_(Direction.DOWN).m_122173_(Direction.DOWN).m_122173_(facing.m_122424_());
            this.setColumn(levelReader, tombSelector, leftPos.m_121945_(Direction.DOWN), random);
            this.setColumn(levelReader, tombSelector, rightPos.m_121945_(Direction.DOWN), random);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            this.setBlockStateSafeWithPlacement(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_());
            leftPos.m_122173_(Direction.UP);
            rightPos.m_122173_(Direction.UP);
            this.setBlockStateRandom(levelReader, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.m_74401_(), structurePlacementData.m_74404_(), random, 0.5f);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, STAIR_SELECTOR.get(random), blockInfoGlobal.f_74677_);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.ZOMBIE_MAIN_STAIRS_PROCESSOR;
    }

    private void setBlockStateSafeWithPlacement(LevelReader levelReader, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation) {
        if (mirror != Mirror.NONE) {
            blockState = blockState.m_60715_(mirror);
        }
        if (rotation != Rotation.NONE) {
            blockState = blockState.m_60717_(rotation);
        }
        this.setBlockStateSafe(levelReader, pos, blockState);
    }

    private void setBlockStateRandom(LevelReader levelReader, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation, RandomSource random, float chance) {
        if (random.m_188501_() < chance) {
            this.setBlockStateSafeWithPlacement(levelReader, blockState, pos, mirror, rotation);
        }
    }

    private void setColumn(LevelReader levelReader, BlockStateRandomizer selector, BlockPos pos, RandomSource random) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        Optional currBlock = this.getBlockStateSafe(levelReader, (BlockPos)mutable);
        while (mutable.m_123342_() > levelReader.m_141937_() && (currBlock.isEmpty() || ((BlockState)currBlock.get()).m_60767_() == Material.f_76296_ || ((BlockState)currBlock.get()).m_60767_() == Material.f_76305_ || ((BlockState)currBlock.get()).m_60767_() == Material.f_76307_)) {
            if ((double)random.m_188501_() > 0.3) {
                this.setBlockStateSafe(levelReader, (BlockPos)mutable, selector.get(random));
            }
            mutable.m_122173_(Direction.DOWN);
            currBlock = this.getBlockStateSafe(levelReader, (BlockPos)mutable);
        }
    }
}

