/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.util;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.entities.HordeGraveyardEntity;
import com.finallion.graveyard.init.TGEntities;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeHooks;

public class TGCommands {
    public static void init() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_138815_) {
        p_138815_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"horde").requires(p_138819_ -> p_138819_.m_6761_(3))).then(Commands.m_82127_((String)"trigger").executes(context -> TGCommands.executeSpawn((CommandSourceStack)context.getSource()))));
    }

    public static int executeSpawn(CommandSourceStack source) {
        source.m_81354_((Component)Component.m_237113_((String)"Spawned a graveyard horde."), false);
        int o = (Integer)GraveyardConfig.COMMON.mobSpawnAttempts.get();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(source.m_81371_().f_82479_, source.m_81371_().f_82480_, source.m_81371_().f_82481_);
        ServerLevel level = source.m_81372_();
        RandomSource random = source.m_81372_().m_213780_();
        boolean illagerSpawn = random.m_188499_();
        for (int l1 = 0; l1 < o; ++l1) {
            mutable.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).m_123342_());
            if (l1 == 0) {
                if (!TGCommands.spawnHordeEntity((Level)level, (BlockPos)mutable, random, true, illagerSpawn)) {
                    break;
                }
            } else {
                TGCommands.spawnHordeEntity((Level)level, (BlockPos)mutable, random, false, illagerSpawn);
            }
            mutable.m_142451_(mutable.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
            mutable.m_142443_(mutable.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
        }
        return 1;
    }

    private static boolean spawnHordeEntity(Level p_64565_, BlockPos p_64566_, RandomSource p_64567_, boolean p_64568_, boolean illagerSpawn) {
        HordeGraveyardEntity hordeEntity;
        if (!illagerSpawn) {
            hordeEntity = p_64567_.m_188499_() ? (HordeGraveyardEntity)((EntityType)TGEntities.GHOUL.get()).m_20615_(p_64565_) : (HordeGraveyardEntity)((EntityType)TGEntities.REVENANT.get()).m_20615_(p_64565_);
        } else {
            int rand = p_64567_.m_188503_(5);
            switch (rand) {
                case 0: 
                case 1: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.CORRUPTED_PILLAGER.get()).m_20615_(p_64565_);
                    break;
                }
                case 2: 
                case 3: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.CORRUPTED_VINDICATOR.get()).m_20615_(p_64565_);
                    break;
                }
                default: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.ACOLYTE.get()).m_20615_(p_64565_);
                }
            }
        }
        if (hordeEntity != null) {
            if (p_64568_) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.findPatrolTarget();
            }
            hordeEntity.m_6034_(p_64566_.m_123341_(), p_64566_.m_123342_(), p_64566_.m_123343_());
            if (ForgeHooks.canEntitySpawn((Mob)hordeEntity, (LevelAccessor)p_64565_, (double)p_64566_.m_123341_(), (double)p_64566_.m_123342_(), (double)p_64566_.m_123343_(), null, (MobSpawnType)MobSpawnType.PATROL) == -1) {
                return false;
            }
            hordeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)p_64565_), p_64565_.m_6436_(p_64566_), MobSpawnType.PATROL, null, null);
            ((ServerLevel)p_64565_).m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

