/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.init.TGSounds;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ReaperEntity
extends HostileGraveyardEntity
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final AnimationBuilder DEATH_ANIMATION = new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder SPAWN_ANIMATION = new AnimationBuilder().addAnimation("spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder ATTACK_ANIMATION = new AnimationBuilder().addAnimation("attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    protected final byte ANIMATION_IDLE = 0;
    protected final byte ANIMATION_WALK = 1;
    protected final byte ANIMATION_SPAWN = (byte)2;
    protected final byte ANIMATION_DEATH = (byte)3;
    protected final byte ANIMATION_ATTACK = (byte)4;
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(ReaperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ReaperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos boundOrigin;
    Mob owner;
    @Nullable
    private BlockPos bounds;

    public ReaperEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world, "reaper");
        this.f_21342_ = new MoveHelperController(this);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag p_34008_) {
        super.m_7378_(p_34008_);
        if (p_34008_.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(p_34008_.m_128451_("BoundX"), p_34008_.m_128451_("BoundY"), p_34008_.m_128451_("BoundZ"));
        }
    }

    @Override
    public void m_7380_(CompoundTag p_34015_) {
        super.m_7380_(p_34015_);
        if (this.boundOrigin != null) {
            p_34015_.m_128405_("BoundX", this.boundOrigin.m_123341_());
            p_34015_.m_128405_("BoundY", this.boundOrigin.m_123342_());
            p_34015_.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new ChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new MoveRandomGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6478_(MoverType p_33997_, Vec3 p_33998_) {
        super.m_6478_(p_33997_, p_33998_);
        this.m_20101_();
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationController controller = event.getController();
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean isDying = this.m_21224_();
        boolean isAttacking = this.m_5912_();
        if (isDying) {
            controller.setAnimation(this.DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (isAttacking || this.isCharging()) {
            controller.setAnimation(this.ATTACK_ANIMATION);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 4: {
                controller.setAnimation(this.ATTACK_ANIMATION);
                break;
            }
            default: {
                controller.setAnimation(isMoving ? this.WALK_ANIMATION : this.IDLE_ANIMATION);
            }
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos p_190651_1_) {
        this.boundOrigin = p_190651_1_;
    }

    private boolean getVexFlag(int p_190656_1_) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & p_190656_1_) != 0;
    }

    private void setVexFlag(int p_190660_1_, boolean p_190660_2_) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = p_190660_2_ ? (i |= p_190660_1_) : (i &= ~p_190660_1_);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean p_190648_1_) {
        this.setVexFlag(1, p_190648_1_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    public byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)TGSounds.REAPER_AMBIENT.get(), 1.0f, -10.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_((SoundEvent)TGSounds.REAPER_HURT.get(), 1.0f, -10.0f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TGSounds.REAPER_DEATH.get();
    }

    public float m_6100_() {
        return -10.0f;
    }

    class MoveHelperController
    extends MoveControl {
        public MoveHelperController(ReaperEntity p_34062_) {
            super((Mob)p_34062_);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - ReaperEntity.this.m_20185_(), this.f_24976_ - ReaperEntity.this.m_20186_(), this.f_24977_ - ReaperEntity.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < ReaperEntity.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    ReaperEntity.this.m_20256_(ReaperEntity.this.m_20184_().m_82490_(0.5));
                } else {
                    ReaperEntity.this.m_20256_(ReaperEntity.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (ReaperEntity.this.m_5448_() == null) {
                        Vec3 vec31 = ReaperEntity.this.m_20184_();
                        ReaperEntity.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        ReaperEntity.this.f_20883_ = ReaperEntity.this.m_146908_();
                    } else {
                        double d2 = ReaperEntity.this.m_5448_().m_20185_() - ReaperEntity.this.m_20185_();
                        double d1 = ReaperEntity.this.m_5448_().m_20189_() - ReaperEntity.this.m_20189_();
                        ReaperEntity.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        ReaperEntity.this.f_20883_ = ReaperEntity.this.m_146908_();
                    }
                }
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (ReaperEntity.this.m_5448_() != null && !ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.f_19796_.m_188503_(7) == 0) {
                return ReaperEntity.this.m_20280_((Entity)ReaperEntity.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.isCharging() && ReaperEntity.this.m_5448_() != null && ReaperEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = ReaperEntity.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                ReaperEntity.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            ReaperEntity.this.setIsCharging(true);
            ReaperEntity.this.m_5496_((SoundEvent)TGSounds.REAPER_CHARGE.get(), 1.0f, -10.0f);
        }

        public void m_8041_() {
            ReaperEntity.this.setIsCharging(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = ReaperEntity.this.m_5448_();
            if (livingentity != null) {
                if (ReaperEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    ReaperEntity.this.m_7327_((Entity)livingentity);
                    ReaperEntity.this.setIsCharging(false);
                } else {
                    double d0 = ReaperEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        ReaperEntity.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !ReaperEntity.this.m_21566_().m_24995_() && ReaperEntity.this.f_19796_.m_188503_(7) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = ReaperEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = ReaperEntity.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(ReaperEntity.this.f_19796_.m_188503_(15) - 7, ReaperEntity.this.f_19796_.m_188503_(11) - 5, ReaperEntity.this.f_19796_.m_188503_(15) - 7);
                if (!ReaperEntity.this.f_19853_.m_46859_(blockpos1)) continue;
                ReaperEntity.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (ReaperEntity.this.m_5448_() != null) break;
                ReaperEntity.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(PathfinderMob p_i47231_2_) {
            super((Mob)p_i47231_2_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return ReaperEntity.this.owner != null && ReaperEntity.this.owner.m_5448_() != null && this.m_26150_(ReaperEntity.this.owner.m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            ReaperEntity.this.m_6710_(ReaperEntity.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

