/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends StandingSignBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty FLOOR = BlockStateProperties.f_61427_;
    private static final VoxelShape SHAPE_FACING_EW = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_FACING_NS = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private final ResourceLocation texture;

    public GravestoneBlock(ResourceLocation texture) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60910_().m_60955_().m_60918_(SoundType.f_56718_).m_60978_(1.5f), WoodType.f_61830_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_56268_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
        this.texture = texture;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLOOR, f_56268_, ROTATION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (Direction.NORTH == state.m_61143_((Property)FACING) || Direction.SOUTH == state.m_61143_((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState p_56278_, Level p_56279_, BlockPos p_56280_, Player p_56281_, InteractionHand p_56282_, BlockHitResult p_56283_) {
        boolean flag3;
        ItemStack itemstack = p_56281_.m_21120_(p_56282_);
        Item item = itemstack.m_41720_();
        boolean flag = item instanceof DyeItem;
        boolean flag1 = itemstack.m_150930_(Items.f_151056_);
        boolean flag2 = itemstack.m_150930_(Items.f_42532_);
        boolean bl = flag3 = (flag1 || flag || flag2) && p_56281_.m_150110_().f_35938_;
        if (p_56279_.f_46443_) {
            return flag3 ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        BlockEntity blockentity = p_56279_.m_7702_(p_56280_);
        if (!(blockentity instanceof GravestoneBlockEntity)) {
            return InteractionResult.PASS;
        }
        GravestoneBlockEntity signblockentity = (GravestoneBlockEntity)blockentity;
        boolean flag4 = signblockentity.hasGlowingText();
        if (!(flag1 && flag4 || flag2 && !flag4)) {
            if (flag3) {
                boolean flag5;
                if (flag1) {
                    p_56279_.m_5594_((Player)null, p_56280_, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    flag5 = signblockentity.setHasGlowingText(true);
                    if (p_56281_ instanceof ServerPlayer) {
                        CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)p_56281_, p_56280_, itemstack);
                    }
                } else if (flag2) {
                    p_56279_.m_5594_((Player)null, p_56280_, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    flag5 = signblockentity.setHasGlowingText(false);
                } else {
                    p_56279_.m_5594_((Player)null, p_56280_, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    flag5 = signblockentity.setColor(((DyeItem)item).m_41089_());
                }
                if (flag5) {
                    if (!p_56281_.m_7500_()) {
                        itemstack.m_41774_(1);
                    }
                    p_56281_.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                }
            }
            return signblockentity.executeClickCommands((ServerPlayer)p_56281_) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GravestoneBlockEntity(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack p_49851_) {
        if (placer != null && placer instanceof Player) {
            GravestoneBlockEntity sign = (GravestoneBlockEntity)world.m_7702_(pos);
            if (!world.f_46443_) {
                sign.setAllowedPlayerEditor(placer.m_20148_());
                ((ServerPlayer)placer).f_8906_.m_9829_((Packet)new ClientboundOpenSignEditorPacket(pos));
            } else {
                sign.setEditable(true);
            }
        }
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (Direction.NORTH == state.m_61143_((Property)FACING) || Direction.SOUTH == state.m_61143_((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public BlockState m_7417_(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.m_61143_((Property)f_56268_)).booleanValue()) {
            p_196271_4_.m_186469_(p_196271_5_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_196271_4_));
        }
        return super.m_7417_(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_8125_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_((Property)f_56268_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return p_196260_2_.m_8055_(p_196260_3_.m_7495_()).m_60767_().m_76333_();
    }
}

