/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities.render;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import com.finallion.graveyard.blocks.GravestoneBlock;
import com.finallion.graveyard.init.TGBlocks;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GravestoneBlockEntityRenderer
implements BlockEntityRenderer<GravestoneBlockEntity> {
    private static final int RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font font;
    private static final HashMap<Block, RenderType> LAYERS = Maps.newHashMap();
    private static RenderType defaultLayer = RenderType.m_110446_((ResourceLocation)new ResourceLocation("textures/entity/signs/oak.png"));

    public GravestoneBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.font = ctx.m_173586_();
    }

    public void render(GravestoneBlockEntity signBlockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int p_112501_, int p_112502_) {
        int l;
        boolean flag;
        int k;
        BlockState blockState = signBlockEntity.m_58900_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.25, 0.5);
        float rotation = -((Direction)blockState.m_61143_((Property)GravestoneBlock.FACING)).m_122435_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 0.3333333432674408, 0.23);
        matrixStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int i = GravestoneBlockEntityRenderer.getDarkColor(signBlockEntity);
        FormattedCharSequence[] aformattedcharsequence = signBlockEntity.getRenderMessages(Minecraft.m_91087_().m_167974_(), p_173653_ -> {
            List list = this.font.m_92923_((FormattedText)p_173653_, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (signBlockEntity.hasGlowingText()) {
            k = signBlockEntity.getColor().m_41071_();
            flag = GravestoneBlockEntityRenderer.isOutlineVisible(signBlockEntity, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = p_112501_;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, i, matrixStack.m_85850_().m_85861_(), vertexConsumerProvider, l);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(i1 * 10 - 20), k, false, matrixStack.m_85850_().m_85861_(), vertexConsumerProvider, false, 0, l);
        }
        matrixStack.m_85849_();
        this.renderGrave(blockState, f, matrixStack, vertexConsumerProvider, p_112501_, p_112502_);
    }

    public void renderGrave(BlockState state, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.43, 0.5);
        matrixStack.m_85841_(2.28f, 2.15f, 2.28f);
        float rotation = -((Direction)state.m_61143_((Property)GravestoneBlock.FACING)).m_122435_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1), ItemTransforms.TransformType.GROUND, i, j, matrixStack, vertexConsumerProvider, 2);
        matrixStack.m_85849_();
    }

    private static boolean isOutlineVisible(GravestoneBlockEntity p_173642_, int p_173643_) {
        if (p_173643_ == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)p_173642_.m_58899_())) < (double)RENDER_DISTANCE;
    }

    private static int getDarkColor(GravestoneBlockEntity p_173640_) {
        int i = p_173640_.getColor().m_41071_();
        double d0 = 0.4;
        int j = (int)((double)NativeImage.m_85085_((int)i) * 0.4);
        int k = (int)((double)NativeImage.m_85103_((int)i) * 0.4);
        int l = (int)((double)NativeImage.m_85119_((int)i) * 0.4);
        return i == DyeColor.BLACK.m_41071_() && p_173640_.hasGlowingText() ? -988212 : NativeImage.m_84992_((int)0, (int)l, (int)k, (int)j);
    }

    public static WoodType getSignType(Block block) {
        WoodType signType2 = block instanceof GravestoneBlock ? ((GravestoneBlock)block).m_56297_() : WoodType.f_61836_;
        return signType2;
    }

    public static SignRenderer.SignModel createSignModel(EntityModelSet p_173647_, WoodType p_173648_) {
        return new SignRenderer.SignModel(p_173647_.m_171103_(ModelLayers.m_171291_((WoodType)p_173648_)));
    }

    public static VertexConsumer getConsumer(MultiBufferSource provider, Block block) {
        return provider.m_6299_(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        RenderType layer1 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/polished_basalt.png"));
        RenderType layer2 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/cobblestone.png"));
        RenderType layer3 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/mossy_cobblestone.png"));
        RenderType layer4 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/deepslate.png"));
        RenderType layer5 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/blackstone.png"));
        RenderType layer6 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/cracked_blackstone.png"));
        RenderType layer7 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/stone_bricks.png"));
        RenderType layer8 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/mossy_stone_bricks.png"));
        RenderType layer9 = RenderType.m_110446_((ResourceLocation)new ResourceLocation("graveyard", "textures/entity/gravestone/bricks.png"));
        RenderType layer10 = RenderType.m_110446_((ResourceLocation)TGBlocks.RED_SANDSTONE_GRAVESTONE_TEXTURE);
        RenderType layer11 = RenderType.m_110446_((ResourceLocation)TGBlocks.SANDSTONE_GRAVESTONE_TEXTURE);
        RenderType layer12 = RenderType.m_110446_((ResourceLocation)TGBlocks.GILDED_BLACKSTONE_GRAVESTONE_TEXTURE);
        RenderType layer13 = RenderType.m_110446_((ResourceLocation)TGBlocks.QUARTZ_BRICKS_GRAVESTONE_TEXTURE);
        LAYERS.put((Block)TGBlocks.GRAVESTONE.get(), layer1);
        LAYERS.put((Block)TGBlocks.COBBLESTONE_GRAVESTONE.get(), layer2);
        LAYERS.put((Block)TGBlocks.MOSSY_COBBLESTONE_GRAVESTONE.get(), layer3);
        LAYERS.put((Block)TGBlocks.DEEPSLATE_GRAVESTONE.get(), layer4);
        LAYERS.put((Block)TGBlocks.BLACKSTONE_GRAVESTONE.get(), layer5);
        LAYERS.put((Block)TGBlocks.CRACKED_BLACKSTONE_GRAVESTONE.get(), layer6);
        LAYERS.put((Block)TGBlocks.STONE_BRICKS_GRAVESTONE.get(), layer7);
        LAYERS.put((Block)TGBlocks.MOSSY_STONE_BRICKS_GRAVESTONE.get(), layer8);
        LAYERS.put((Block)TGBlocks.BRICKS_GRAVESTONE.get(), layer9);
        LAYERS.put((Block)TGBlocks.RED_SANDSTONE_GRAVESTONE.get(), layer10);
        LAYERS.put((Block)TGBlocks.SANDSTONE_GRAVESTONE.get(), layer11);
        LAYERS.put((Block)TGBlocks.GILDED_BLACKSTONE_GRAVESTONE.get(), layer12);
        LAYERS.put((Block)TGBlocks.QUARTZ_BRICKS_GRAVESTONE.get(), layer13);
    }
}

