/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blockentities;

import com.finallion.graveyard.blocks.OssuaryBlock;
import com.finallion.graveyard.init.TGSounds;
import com.finallion.graveyard.init.TGTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OssuaryBlockEntity
extends BlockEntity
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final AnimationBuilder OPEN = new AnimationBuilder().addAnimation("open", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE).addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder CLOSE = new AnimationBuilder().addAnimation("close", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME);
    private final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private boolean playedSound = false;
    private boolean canClose = false;
    private int timer = 0;

    public OssuaryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TGTileEntities.OSSUARY_BLOCK_ENTITY.get(), pos, state);
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        AnimationState state = event.getController().getAnimationState();
        if (this.timer > 0) {
            --this.timer;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)OssuaryBlock.OPEN)).booleanValue()) {
            if (state == AnimationState.Stopped) {
                Player playerEntity;
                if (this.f_58857_ != null && !this.playedSound && (playerEntity = this.f_58857_.m_45924_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 4.0, false)) != null) {
                    playerEntity.m_6330_((SoundEvent)TGSounds.OSSUARY_OPEN.get(), SoundSource.BLOCKS, 1.0f, -2.0f);
                    this.playedSound = true;
                    this.timer = 160;
                }
                event.getController().setAnimation(this.OPEN);
            }
            return PlayState.CONTINUE;
        }
        if (!((Boolean)this.m_58900_().m_61143_((Property)OssuaryBlock.OPEN)).booleanValue() && this.timer == 0) {
            event.getController().setAnimation(this.CLOSE);
            if (this.playedSound) {
                this.playedSound = false;
            }
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, OssuaryBlockEntity blockEntity) {
        Player playerEntity;
        if (world.f_46441_.m_188503_(100) == 0) {
            world.m_5594_(null, pos, SoundEvents.f_12404_, SoundSource.BLOCKS, 4.0f, -3.0f);
        }
        if ((playerEntity = world.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4.0, false)) != null && !((Boolean)state.m_61143_((Property)OssuaryBlock.OPEN)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OssuaryBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        } else if (playerEntity == null && ((Boolean)state.m_61143_((Property)OssuaryBlock.OPEN)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OssuaryBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

