/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.serializer;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.entity.player.McGameProfile;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.serializer.PacketSerializer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lsu/plo/voice/proto/serializer/McGameProfileSerializer;", "Lsu/plo/voice/proto/serializer/PacketSerializer;", "Lsu/plo/slib/api/entity/player/McGameProfile;", "()V", "deserialize", "buffer", "Lcom/google/common/io/ByteArrayDataInput;", "serialize", "", "obj", "Lcom/google/common/io/ByteArrayDataOutput;", "protocol"})
public final class McGameProfileSerializer
implements PacketSerializer<McGameProfile> {
    @NotNull
    public static final McGameProfileSerializer INSTANCE = new McGameProfileSerializer();

    private McGameProfileSerializer() {
    }

    @Override
    @NotNull
    public McGameProfile deserialize(@NotNull ByteArrayDataInput buffer) throws IOException {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        UUID id = PacketUtil.readUUID(buffer);
        String name = buffer.readUTF();
        int length = PacketUtil.readSafeInt(buffer, 0, 100);
        ArrayList<McGameProfile.Property> properties = new ArrayList<McGameProfile.Property>();
        for (int i = 0; i < length; ++i) {
            String string = buffer.readUTF();
            Intrinsics.checkNotNullExpressionValue(string, "readUTF(...)");
            String string2 = buffer.readUTF();
            Intrinsics.checkNotNullExpressionValue(string2, "readUTF(...)");
            properties.add(new McGameProfile.Property(string, string2, buffer.readUTF()));
        }
        Intrinsics.checkNotNull(id);
        Intrinsics.checkNotNull(name);
        return new McGameProfile(id, name, (List<McGameProfile.Property>)properties);
    }

    @Override
    public void serialize(@NotNull McGameProfile obj, @NotNull ByteArrayDataOutput buffer) throws IOException {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        PacketUtil.writeUUID(buffer, (UUID)Preconditions.checkNotNull((Object)obj.getId()));
        buffer.writeUTF((String)Preconditions.checkNotNull((Object)obj.getName()));
        buffer.writeInt(obj.getProperties().size());
        for (McGameProfile.Property property : obj.getProperties()) {
            String propertyName = property.component1();
            String propertyValue = property.component2();
            String propertySignature = property.component3();
            buffer.writeUTF(propertyName);
            buffer.writeUTF(propertyValue);
            String string = propertySignature;
            if (string == null) {
                string = "";
            }
            buffer.writeUTF(string);
        }
    }
}

