/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Optional;
import lombok.NonNull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.VertexBuilder;
import su.plo.lib.mod.client.render.VertexFormatMode;
import su.plo.lib.mod.extensions.PoseStackKt;
import su.plo.slib.api.chat.component.McLiteralText;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.slib.api.position.Pos3d;
import su.plo.slib.mod.extension.ScoreboardKt;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.audio.source.ClientStaticSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.LivingEntityRenderEvent;
import su.plo.voice.client.event.render.LevelRenderEvent;
import su.plo.voice.client.extension.MathKt;
import su.plo.voice.client.gui.PlayerVolumeAction;
import su.plo.voice.client.render.ModCamera;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;

public final class SourceIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final PlayerVolumeAction volumeAction;

    public SourceIconRenderer(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull PlayerVolumeAction volumeAction) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.volumeAction = volumeAction;
        LivingEntityRenderEvent.INSTANCE.registerListener(this::onLivingEntityRender);
    }

    @EventSubscribe
    public void onLevelRender(@NotNull LevelRenderEvent event) {
        if (this.isIconHidden() || !((Boolean)this.config.getOverlay().getShowStaticSourceIcons().value()).booleanValue()) {
            return;
        }
        for (ClientAudioSource source2 : this.voiceClient.getSourceManager().getSources()) {
            if (!(source2.getSourceInfo() instanceof StaticSourceInfo) || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !source2.isActivated()) continue;
            Optional sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId());
            if (!sourceLine.isPresent()) {
                return;
            }
            ClientStaticSource staticSource = (ClientStaticSource)source2;
            Pos3d sourcePosition = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
            this.renderStatic(event.getStack(), event.getCamera(), event.getLightSupplier().getLight(sourcePosition), ResourceLocation.m_135820_((String)((ClientSourceLine)sourceLine.get()).getIcon()), staticSource, event.getDelta());
        }
    }

    private void onLivingEntityRender(@NotNull LivingEntity entity, @NotNull PoseStack stack, int light, boolean shouldShowName) {
        if (entity instanceof Player) {
            this.renderPlayer((Player)entity, stack, light, shouldShowName);
        } else {
            this.renderLivingEntity(entity, stack, light, shouldShowName);
        }
    }

    private void renderPlayer(@NotNull Player player, @NotNull PoseStack stack, int light, boolean shouldShowName) {
        String iconLocation;
        boolean isFakePlayer;
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        boolean bl = isFakePlayer = !Minecraft.m_91087_().m_91403_().m_105143_().contains(player.m_20148_());
        if (this.isIconHidden() || player.m_20148_().equals(clientPlayer.m_20148_()) || isFakePlayer || player.m_20177_((Player)clientPlayer)) {
            return;
        }
        boolean hasPercent = false;
        Optional<VoicePlayerInfo> playerInfo = connection.get().getPlayerById(player.m_20148_());
        if (!playerInfo.isPresent()) {
            iconLocation = "plasmovoice:textures/icons/headset_not_installed.png";
        } else if (((Boolean)this.config.getVoice().getVolumes().getMute("source_" + player.m_20148_()).value()).booleanValue()) {
            iconLocation = "plasmovoice:textures/icons/speaker_disabled.png";
        } else if (playerInfo.get().isMuted()) {
            iconLocation = "plasmovoice:textures/icons/speaker_muted.png";
        } else if (playerInfo.get().isVoiceDisabled()) {
            iconLocation = "plasmovoice:textures/icons/headset_disabled.png";
        } else {
            Collection sources = this.voiceClient.getSourceManager().getPlayerSources(player.m_20148_());
            hasPercent = this.volumeAction.isShown(player);
            if (hasPercent) {
                this.renderPercent((Entity)player, stack, light, shouldShowName);
            }
            if (sources.isEmpty()) {
                return;
            }
            ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
            if (highestSourceLine == null) {
                return;
            }
            iconLocation = highestSourceLine.getIcon();
        }
        this.renderEntity((Entity)player, stack, light, shouldShowName, ResourceLocation.m_135820_((String)iconLocation), hasPercent);
    }

    private void renderLivingEntity(@NotNull LivingEntity entity, @NotNull PoseStack stack, int light, boolean shouldShowName) {
        Optional<ServerConnection> connection = this.voiceClient.getServerConnection();
        if (!connection.isPresent()) {
            return;
        }
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        if (this.isIconHidden() || entity.m_20177_((Player)clientPlayer)) {
            return;
        }
        Collection sources = this.voiceClient.getSourceManager().getEntitySources(entity.m_19879_());
        ClientSourceLine highestSourceLine = this.getHighestActivatedSourceLine(sources);
        if (highestSourceLine == null) {
            return;
        }
        this.renderEntity((Entity)entity, stack, light, shouldShowName, ResourceLocation.m_135820_((String)highestSourceLine.getIcon()), false);
    }

    private void renderEntity(@NonNull Entity entity, @NonNull PoseStack stack, int light, boolean hasLabel, @NonNull ResourceLocation iconLocation, boolean hasPercent) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (iconLocation == null) {
            throw new NullPointerException("iconLocation is marked non-null but is null");
        }
        Vec3 position = entity.m_20182_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double distance = camera.m_90583_().m_82531_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        if (distance > 4096.0) {
            return;
        }
        stack.m_85836_();
        if (hasPercent) {
            stack.m_85837_(0.0, 0.3, 0.0);
        }
        this.translateEntityMatrix(entity, camera, stack, distance, hasLabel);
        if (entity.m_20164_()) {
            this.vertices(stack, 40, light, iconLocation, false);
        } else {
            this.vertices(stack, 255, light, iconLocation, false);
            this.vertices(stack, 40, light, iconLocation, true);
        }
        stack.m_85849_();
    }

    private void renderPercent(@NotNull Entity entity, @NonNull PoseStack stack, int light, boolean hasLabel) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        Vec3 position = entity.m_20182_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double distance = camera.m_90583_().m_82531_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        if (distance > 4096.0) {
            return;
        }
        stack.m_85836_();
        this.translateEntityMatrix(entity, camera, stack, distance, hasLabel);
        stack.m_85837_(5.0, 0.0, 0.0);
        DoubleConfigEntry volume = this.config.getVoice().getVolumes().getVolume("source_" + entity.m_20148_());
        McLiteralText text = McTextComponent.literal((int)Math.round((Double)volume.value() * 100.0) + "%");
        int backgroundColor = 0x3F000000;
        int xOffset = -RenderUtil.getTextWidth(text) / 2;
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69458_((boolean)false);
        RenderUtil.fill(stack, xOffset - 1, -1, xOffset + RenderUtil.getTextWidth(text) + 1, 8, backgroundColor);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, 0x20FFFFFF, light, !entity.m_20164_(), false);
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)true);
        RenderUtil.drawStringLight(stack, text, xOffset, 0, -1, light, false, false);
        RenderSystem.m_69461_();
        stack.m_85849_();
    }

    private void translateEntityMatrix(@NotNull Entity entity, @NonNull Camera camera, @NonNull PoseStack stack, double distance, boolean hasLabel) {
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (hasLabel) {
            Player player;
            Objective belowNameObjective;
            stack.m_85837_(0.0, 0.3, 0.0);
            if (entity instanceof Player && (belowNameObjective = ScoreboardKt.getObjectiveBelowName((player = (Player)entity).m_36329_())) != null && distance < 100.0) {
                stack.m_85837_(0.0, 0.3, 0.0);
            }
        }
        stack.m_85837_(0.0, (double)entity.m_20206_() + 0.5, 0.0);
        PoseStackKt.rotate(stack, -camera.m_90590_(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.m_90589_(), 1.0f, 0.0f, 0.0f);
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        stack.m_85837_(-5.0, -1.0, 0.0);
    }

    private void renderStatic(@NonNull PoseStack stack, @NonNull ModCamera camera, int light, @NotNull ResourceLocation iconLocation, @NotNull ClientStaticSource staticSource, double delta) {
        Pos3d lastPosition;
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (camera == null) {
            throw new NullPointerException("camera is marked non-null but is null");
        }
        Pos3d position = ((StaticSourceInfo)staticSource.getSourceInfo()).getPosition();
        if (position.distanceSquared(lastPosition = staticSource.getLastRenderPosition()) > 1.0) {
            lastPosition.setX(position.getX());
            lastPosition.setY(position.getY());
            lastPosition.setZ(position.getZ());
        } else {
            lastPosition.setX(Mth.m_14139_((double)delta, (double)lastPosition.getX(), (double)position.getX()));
            lastPosition.setY(Mth.m_14139_((double)delta, (double)lastPosition.getY(), (double)position.getY()));
            lastPosition.setZ(Mth.m_14139_((double)delta, (double)lastPosition.getZ(), (double)position.getZ()));
        }
        double distanceToCamera = camera.position().m_82557_(MathKt.toVec3(lastPosition));
        if (distanceToCamera > 4096.0) {
            return;
        }
        stack.m_85836_();
        stack.m_85837_(lastPosition.getX() - camera.position().f_82479_, lastPosition.getY() - camera.position().f_82480_, lastPosition.getZ() - camera.position().f_82481_);
        PoseStackKt.rotate(stack, -camera.pitch(), 0.0f, 1.0f, 0.0f);
        PoseStackKt.rotate(stack, camera.yaw(), 1.0f, 0.0f, 0.0f);
        stack.m_85841_(-0.025f, -0.025f, 0.025f);
        stack.m_85837_(-5.0, 0.0, 0.0);
        this.vertices(stack, 255, light, iconLocation, false);
        this.vertices(stack, 40, light, iconLocation, true);
        stack.m_85849_();
    }

    private void vertices(@NonNull PoseStack stack, int alpha, int light, @NotNull ResourceLocation iconLocation, boolean seeThrough) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (seeThrough) {
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
        } else {
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)true);
        }
        RenderType renderType = seeThrough ? RenderType.m_110500_((ResourceLocation)iconLocation) : RenderType.m_110497_((ResourceLocation)iconLocation);
        BufferBuilder buffer = RenderUtil.beginBufferWithDefaultShader(VertexFormatMode.QUADS, renderType.m_110508_());
        this.vertex(stack, buffer, 0.0f, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
        this.vertex(stack, buffer, 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
        this.vertex(stack, buffer, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        renderType.m_110412_(buffer, 0, 0, 0);
    }

    private void vertex(@NonNull PoseStack stack, @NonNull BufferBuilder buffer, float x, float y, float z, float u, float v, int alpha, int light) {
        if (stack == null) {
            throw new NullPointerException("stack is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        VertexBuilder.create(buffer).position(stack, x, y, z).color(255, 255, 255, alpha).uv(u, v).light(light).normal(stack, 0.0f, 0.0f, -1.0f).end();
    }

    private boolean isIconHidden() {
        int showIcons = (Integer)this.config.getOverlay().getShowSourceIcons().value();
        return showIcons == 2 || Minecraft.m_91087_().f_91066_.f_92062_ && showIcons == 0;
    }

    private <T extends SourceInfo> ClientSourceLine getHighestActivatedSourceLine(@NotNull Collection<ClientAudioSource<T>> sources) {
        SourceLine highestSourceLine = null;
        for (ClientAudioSource<T> source2 : sources) {
            Optional sourceLine;
            if (!source2.isActivated() || !((SourceInfo)source2.getSourceInfo()).isIconVisible() || !(sourceLine = this.voiceClient.getSourceLineManager().getLineById(((SourceInfo)source2.getSourceInfo()).getLineId())).isPresent() || highestSourceLine != null && highestSourceLine.getWeight() >= ((ClientSourceLine)sourceLine.get()).getWeight()) continue;
            highestSourceLine = (ClientSourceLine)sourceLine.get();
        }
        return highestSourceLine;
    }
}

