/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.shader.SolidColorShader;
import su.plo.slib.api.chat.component.McTextComponent;

public final class TabButton
extends Button {
    private final boolean shadow;
    private final int shadowColor;
    private final ResourceLocation iconLocation;
    private final ResourceLocation disabledIconLocation;

    public TabButton(int x, int y, int width, int height, @NotNull McTextComponent text, @NotNull ResourceLocation iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow) {
        this(x, y, width, height, text, iconLocation, pressAction, tooltipAction, shadow, -1);
    }

    public TabButton(int x, int y, int width, int height, @NotNull McTextComponent text, @NotNull ResourceLocation iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow, int shadowColor) {
        super(x, y, width, height, text, pressAction, tooltipAction);
        this.shadow = shadow;
        this.shadowColor = shadowColor;
        this.iconLocation = iconLocation;
        this.disabledIconLocation = ResourceLocationUtil.tryBuild(iconLocation.m_135827_(), iconLocation.m_135815_().replace(".png", "_disabled.png"));
    }

    @Override
    protected void renderText(@NotNull PoseStack stack, int mouseX, int mouseY) {
        RenderUtil.bindTexture(0, this.iconLocation);
        if (this.shadow) {
            int textureId = RenderSystem.m_157203_((int)0);
            int shadowColor = this.active ? this.shadowColor : -6250336;
            SolidColorShader.bind(textureId);
            RenderUtil.blitWithActiveShader(stack, DefaultVertexFormat.f_85819_, this.x + 7, this.x + 7 + 8, this.y + 7, this.y + 7 + 8, 0, 0.0f, 1.0f, 0.0f, 1.0f, (int)((double)(shadowColor >> 16 & 0xFF) * 0.25), (int)((double)(shadowColor >> 8 & 0xFF) * 0.25), (int)((double)(shadowColor & 0xFF) * 0.25), shadowColor >> 24 & 0xFF);
            SolidColorShader.unbind();
        }
        RenderUtil.blit(stack, this.x + 6, this.y + 6, 0.0f, 0.0f, 8, 8, 8, 8);
        int textColor = this.active ? COLOR_WHITE : COLOR_GRAY;
        RenderUtil.drawString(stack, this.getText(), this.x + 16, this.y + (this.height - 8) / 2, textColor | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    private ResourceLocation getIconLocation() {
        return this.active ? this.iconLocation : this.disabledIconLocation;
    }
}

