/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.mod.client.gui.components.TextFieldWidget;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class NumberTextFieldWidget
extends TextFieldWidget
implements UpdatableWidget {
    private static final Pattern PATTERN = Pattern.compile("[0-9]+$");
    private final IntConfigEntry entry;

    public NumberTextFieldWidget(@NotNull IntConfigEntry entry, int x, int y, int width, int height) {
        super(x, y, width, height, McTextComponent.empty());
        this.entry = entry;
        this.setResponder(s -> {
            if (s.isEmpty()) {
                entry.reset();
                return;
            }
            try {
                entry.set(Math.max(entry.getMin() + 1, Integer.parseInt(s)));
            }
            catch (NumberFormatException ignored) {
                entry.reset();
            }
        });
        this.setFilter(s -> {
            if (s.isEmpty()) {
                return true;
            }
            if (!PATTERN.matcher((CharSequence)s).matches()) {
                return false;
            }
            int i = Integer.parseInt(s);
            return i > 0 && i <= entry.getMax();
        });
        this.setValue(String.valueOf(entry.value()));
    }

    @Override
    public void updateValue() {
        this.setValue(String.valueOf(this.entry.value()));
    }

    @Override
    public void renderButton(@NotNull PoseStack stack, int mouseX, int mouseY, float delta) {
        ++this.x;
        ++this.y;
        stack.m_85836_();
        RenderSystem.m_69482_();
        stack.m_85837_(0.0, 0.0, 0.0);
        super.renderButton(stack, mouseX, mouseY, delta);
        stack.m_85849_();
    }
}

