/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.gui.settings.VoiceNotAvailableScreen;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lsu/plo/voice/client/gui/settings/VoiceScreens;", "", "()V", "settingsScreen", "Lsu/plo/voice/client/gui/settings/VoiceSettingsScreen;", "openNotAvailable", "", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "openSettings", "plasmovoice-forge-1.19.2"})
public final class VoiceScreens {
    @NotNull
    public static final VoiceScreens INSTANCE = new VoiceScreens();
    @Nullable
    private static VoiceSettingsScreen settingsScreen;

    private VoiceScreens() {
    }

    public final void openSettings(@NotNull BaseVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        Optional<ScreenWrapper> wrappedScreen = ScreenWrapper.getCurrentWrappedScreen();
        Intrinsics.checkNotNull(wrappedScreen);
        ScreenWrapper screenWrapper = OptionalsKt.getOrNull(wrappedScreen);
        if ((screenWrapper != null ? screenWrapper.getScreen() : null) instanceof VoiceSettingsScreen) {
            ScreenWrapper.openScreen(null);
            return;
        }
        if (!voiceClient.getUdpClientManager().isConnected()) {
            this.openNotAvailable(voiceClient);
            return;
        }
        if (settingsScreen == null) {
            settingsScreen = new VoiceSettingsScreen(voiceClient);
        }
        ScreenWrapper.openScreen(settingsScreen);
    }

    public final void openNotAvailable(@NotNull BaseVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter(voiceClient, "voiceClient");
        VoiceNotAvailableScreen notAvailableScreen = new VoiceNotAvailableScreen(voiceClient);
        Optional<UdpClient> optional = voiceClient.getUdpClientManager().getClient();
        Intrinsics.checkNotNullExpressionValue(optional, "getClient(...)");
        Optional<UdpClient> udpClient = optional;
        if (udpClient.isPresent()) {
            if (udpClient.get().isClosed()) {
                notAvailableScreen.setCannotConnect();
            } else {
                notAvailableScreen.setConnecting();
            }
        }
        ScreenWrapper.openScreen(notAvailableScreen);
    }
}

