/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.device;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.slib.api.logging.McLogger;
import su.plo.slib.api.logging.McLoggerFactory;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlContextOutputDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceFactory;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.client.audio.filter.GainFilter;
import su.plo.voice.client.audio.filter.NoiseSuppressionFilter;
import su.plo.voice.client.audio.filter.StereoToMonoFilter;
import su.plo.voice.client.config.VoiceClientConfig;

public final class VoiceDeviceManager
implements DeviceManager {
    private static final McLogger LOGGER = McLoggerFactory.createLogger("VoiceDeviceManager");
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    @Nullable
    private AlContextOutputDevice outputDevice = null;
    @Nullable
    private InputDevice inputDevice = null;
    private ScheduledFuture<?> job;
    private String failedOutputDevices = "";
    private String failedInputDevices = "";

    @Override
    @NotNull
    public Optional<AlContextOutputDevice> getOutputDevice() {
        return Optional.ofNullable(this.outputDevice);
    }

    @Override
    public void setOutputDevice(@Nullable AlContextOutputDevice device) {
        if (this.outputDevice != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.outputDevice);
        }
        this.outputDevice = device;
        if (device != null) {
            this.voiceClient.getEventBus().register(this.voiceClient, device);
        }
    }

    @Override
    @NotNull
    public Optional<InputDevice> getInputDevice() {
        return Optional.ofNullable(this.inputDevice);
    }

    @Override
    public void setInputDevice(@Nullable InputDevice device) {
        if (this.inputDevice != null) {
            this.voiceClient.getEventBus().unregister((Object)this.voiceClient, this.inputDevice);
        }
        this.inputDevice = device;
        if (device != null) {
            this.voiceClient.getEventBus().register(this.voiceClient, device);
        }
    }

    @Override
    @NotNull
    public InputDevice openInputDevice(@Nullable AudioFormat format) throws DeviceException {
        InputDevice device;
        if (Minecraft.f_91002_ && !((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            this.config.getVoice().getUseJavaxInput().set(true);
            this.config.save(true);
        }
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue() && ((Boolean)this.config.getVoice().getStereoCapture().value()).booleanValue()) {
            this.config.getVoice().getStereoCapture().set(false);
            this.config.getVoice().getStereoCapture().setDisabled(true);
            this.config.save(true);
        }
        if (format == null) {
            if (!this.voiceClient.getServerInfo().isPresent()) {
                throw new IllegalStateException("Not connected");
            }
            ServerInfo serverInfo = this.voiceClient.getServerInfo().get();
            format = serverInfo.getVoiceInfo().createFormat((Boolean)this.config.getVoice().getStereoCapture().value());
        }
        if (((Boolean)this.config.getVoice().getUseJavaxInput().value()).booleanValue()) {
            device = this.openJavaxInputDevice(format);
        } else {
            try {
                device = this.openAlInputDevice(format);
            }
            catch (Exception e) {
                BaseVoice.LOGGER.error("Failed to open OpenAL input device, falling back to Javax input device", e);
                device = this.openJavaxInputDevice(format);
            }
        }
        device.addFilter(new StereoToMonoFilter(this.config.getVoice().getStereoCapture()));
        device.addFilter(new GainFilter(this.config.getVoice().getMicrophoneVolume()));
        device.addFilter(new NoiseSuppressionFilter((int)format.getSampleRate(), this.config.getVoice().getNoiseSuppression()));
        return device;
    }

    @Override
    @NotNull
    public AlContextOutputDevice openOutputDevice(@Nullable AudioFormat format) throws DeviceException {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_OUTPUT").orElseThrow(() -> new DeviceException("OpenAL output device factory is not initialized"));
        if (format == null) {
            if (!this.voiceClient.getServerInfo().isPresent()) {
                throw new IllegalStateException("Not connected");
            }
            ServerInfo serverInfo = this.voiceClient.getServerInfo().get();
            format = serverInfo.getVoiceInfo().createFormat(false);
        }
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getOutputDevice());
        return (AlContextOutputDevice)deviceFactory.openDevice(format, deviceName);
    }

    public void startJob() {
        this.job = this.voiceClient.getBackgroundExecutor().scheduleAtFixedRate(() -> {
            try {
                this.tickJob();
            }
            catch (DeviceException e) {
                e.printStackTrace();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void stopJob() {
        if (this.job != null) {
            this.job.cancel(false);
        }
    }

    private synchronized void tickJob() throws DeviceException {
        String deviceNamesString;
        ImmutableList<String> deviceNames;
        DeviceFactory outputFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_OUTPUT").orElseThrow(() -> new DeviceException("OpenAL output device factory is not registered"));
        String inputFactoryName = (Boolean)this.config.getVoice().getUseJavaxInput().value() != false ? "JAVAX_INPUT" : "AL_INPUT";
        DeviceFactory inputFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory(inputFactoryName).orElseThrow(() -> new IllegalStateException("OpenAL input factory is not registered"));
        if (this.outputDevice == null) {
            deviceNames = outputFactory.getDeviceNames();
            deviceNamesString = String.join((CharSequence)"\n", deviceNames);
            if (deviceNames.size() > 0 && !deviceNamesString.equals(this.failedOutputDevices)) {
                try {
                    this.setOutputDevice(this.openOutputDevice(null));
                    this.failedOutputDevices = "";
                }
                catch (Exception e) {
                    LOGGER.error("Failed to open primary OpenAL output device", e);
                    this.failedOutputDevices = deviceNamesString;
                }
                if (!this.voiceClient.getAudioCapture().isActive() && this.inputDevice != null) {
                    this.voiceClient.getAudioCapture().start();
                }
                this.voiceClient.getSourceManager().clear();
            }
        } else if (!this.outputDevice.isOpen()) {
            this.outputDevice.close();
            this.setOutputDevice(null);
        }
        if (this.inputDevice == null) {
            deviceNames = inputFactory.getDeviceNames();
            deviceNamesString = String.join((CharSequence)"\n", deviceNames);
            if (deviceNames.size() > 0 && !deviceNamesString.equals(this.failedInputDevices) && !((Boolean)this.config.getVoice().getDisableInputDevice().value()).booleanValue()) {
                try {
                    this.setInputDevice(this.openInputDevice(null));
                    this.failedInputDevices = "";
                }
                catch (Exception e) {
                    LOGGER.error("Failed to open input device", e);
                    this.failedInputDevices = deviceNamesString;
                }
                if (!this.voiceClient.getAudioCapture().isActive()) {
                    this.voiceClient.getAudioCapture().start();
                }
            }
        } else if (!this.inputDevice.isOpen()) {
            this.inputDevice.close();
            this.setInputDevice(null);
        }
    }

    private InputDevice openAlInputDevice(@NotNull AudioFormat format) throws Exception {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("AL_INPUT").orElseThrow(() -> new IllegalStateException("OpenAL input factory is not registered"));
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getInputDevice());
        return (InputDevice)deviceFactory.openDevice(format, deviceName);
    }

    private InputDevice openJavaxInputDevice(@NotNull AudioFormat format) throws DeviceException {
        DeviceFactory deviceFactory = this.voiceClient.getDeviceFactoryManager().getDeviceFactory("JAVAX_INPUT").orElseThrow(() -> new IllegalStateException("Javax input factory is not registered"));
        String deviceName = this.getDeviceName(deviceFactory, this.config.getVoice().getInputDevice());
        return (InputDevice)deviceFactory.openDevice(format, deviceName);
    }

    @NotNull
    private String getDeviceName(DeviceFactory deviceFactory, ConfigEntry<String> configEntry) {
        String deviceName = configEntry.value();
        if (!Strings.isNullOrEmpty((String)deviceName) && !deviceFactory.getDeviceNames().contains((Object)deviceName)) {
            deviceName = deviceFactory.getDefaultDeviceName();
            configEntry.set("");
        } else if (Strings.isNullOrEmpty((String)deviceName)) {
            deviceName = deviceFactory.getDefaultDeviceName();
        }
        return deviceName;
    }

    public VoiceDeviceManager(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

