/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.api.server.audio.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.api.position.Pos3d;
import su.plo.voice.api.server.audio.capture.PlayerActivationInfo;
import su.plo.voice.api.server.audio.provider.AudioFrameProvider;
import su.plo.voice.api.server.audio.source.AudioSender;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceAudioEndPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%H\u0016J\u001a\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\b\u0010!\u001a\u0004\u0018\u00010\"H&J\u0014\u0010&\u001a\u00020\u00042\n\u0010$\u001a\u0006\u0012\u0002\b\u00030'H&R\u0018\u0010\u0003\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006(\u00c0\u0006\u0001"}, d2={"Lsu/plo/voice/api/server/audio/source/BaseServerDirectSource;", "Lsu/plo/voice/api/server/audio/source/ServerAudioSource;", "Lsu/plo/voice/proto/data/audio/source/DirectSourceInfo;", "isCameraRelative", "", "()Z", "setCameraRelative", "(Z)V", "lookAngle", "Lsu/plo/slib/api/position/Pos3d;", "getLookAngle", "()Lsu/plo/slib/api/position/Pos3d;", "setLookAngle", "(Lsu/plo/slib/api/position/Pos3d;)V", "relativePosition", "getRelativePosition", "setRelativePosition", "sender", "Lsu/plo/voice/api/server/player/VoicePlayer;", "getSender", "()Lsu/plo/voice/api/server/player/VoicePlayer;", "setSender", "(Lsu/plo/voice/api/server/player/VoicePlayer;)V", "createAudioSender", "Lsu/plo/voice/api/server/audio/source/AudioSender;", "frameProvider", "Lsu/plo/voice/api/server/audio/provider/AudioFrameProvider;", "sendAudioEnd", "sequenceNumber", "", "sendAudioFrame", "frame", "", "activationInfo", "Lsu/plo/voice/api/server/audio/capture/PlayerActivationInfo;", "sendAudioPacket", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "sendPacket", "Lsu/plo/voice/proto/packets/Packet;", "server-proxy-common"})
public interface BaseServerDirectSource
extends ServerAudioSource<DirectSourceInfo> {
    @Nullable
    public VoicePlayer getSender();

    public void setSender(@Nullable VoicePlayer var1);

    @Nullable
    public Pos3d getRelativePosition();

    public void setRelativePosition(@Nullable Pos3d var1);

    @Nullable
    public Pos3d getLookAngle();

    public void setLookAngle(@Nullable Pos3d var1);

    public boolean isCameraRelative();

    public void setCameraRelative(boolean var1);

    default public boolean sendAudioEnd(long sequenceNumber) {
        return this.sendPacket(new SourceAudioEndPacket(this.getId(), sequenceNumber));
    }

    default public boolean sendAudioFrame(@NotNull byte[] frame, long sequenceNumber) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return this.sendAudioFrame(frame, sequenceNumber, null);
    }

    default public boolean sendAudioFrame(@NotNull byte[] frame, long sequenceNumber, @Nullable PlayerActivationInfo activationInfo) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        SourceAudioPacket audioPacket = new SourceAudioPacket(sequenceNumber, (byte)this.getState(), frame, this.getId(), 0);
        return this.sendAudioPacket(audioPacket, activationInfo);
    }

    default public boolean sendAudioPacket(@NotNull SourceAudioPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.sendAudioPacket(packet, null);
    }

    public boolean sendAudioPacket(@NotNull SourceAudioPacket var1, @Nullable PlayerActivationInfo var2);

    public boolean sendPacket(@NotNull Packet<?> var1);

    @NotNull
    public AudioSender createAudioSender(@NotNull AudioFrameProvider var1);
}

