/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.logging;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.plo.slib.api.logging.McLogger;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\r\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\fJ/\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\fJ/\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\fR\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lsu/plo/slib/logging/Slf4jLogger;", "Lsu/plo/slib/api/logging/McLogger;", "", "name", "<init>", "(Ljava/lang/String;)V", "format", "", "", "arguments", "", "debug", "(Ljava/lang/String;[Ljava/lang/Object;)V", "error", "getName", "()Ljava/lang/String;", "info", "trace", "warn", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "common"})
public final class Slf4jLogger
implements McLogger {
    @NotNull
    private final Logger logger;

    public Slf4jLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Logger logger = LoggerFactory.getLogger((String)name);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.logger.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    public void trace(@NotNull String format, Object ... arguments) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        this.logger.trace(format, Arrays.copyOf(arguments, arguments.length));
    }

    @Override
    public void debug(@NotNull String format, Object ... arguments) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        this.logger.debug(format, Arrays.copyOf(arguments, arguments.length));
    }

    @Override
    public void info(@NotNull String format, Object ... arguments) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        this.logger.info(format, Arrays.copyOf(arguments, arguments.length));
    }

    @Override
    public void warn(@NotNull String format, Object ... arguments) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        this.logger.warn(format, Arrays.copyOf(arguments, arguments.length));
    }

    @Override
    public void error(@NotNull String format, Object ... arguments) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        this.logger.error(format, Arrays.copyOf(arguments, arguments.length));
    }
}

