/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.language;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.plo.slib.api.language.ServerTranslator;
import su.plo.slib.language.MapServerTranslator;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.Pair;
import su.plo.voice.libs.kotlin.TuplesKt;
import su.plo.voice.libs.kotlin.collections.MapsKt;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048\u0016@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R,\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lsu/plo/slib/language/MapServerTranslator;", "Lsu/plo/slib/api/language/ServerTranslator;", "<init>", "()V", "", "languageName", "", "getLanguage", "(Ljava/lang/String;)Ljava/util/Map;", "languageMap", "", "register", "(Ljava/lang/String;Ljava/util/Map;)V", "value", "defaultLanguage", "Ljava/lang/String;", "getDefaultLanguage", "()Ljava/lang/String;", "setDefaultLanguage", "(Ljava/lang/String;)V", "", "languages", "Ljava/util/Map;", "common"})
public final class MapServerTranslator
implements ServerTranslator {
    @NotNull
    private String defaultLanguage = "en_us";
    @NotNull
    private final Map<String, Map<String, String>> languages;

    public MapServerTranslator() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("en_us", new HashMap())};
        this.languages = MapsKt.hashMapOf(pairArray);
    }

    @Override
    @NotNull
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public void setDefaultLanguage(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.languages.computeIfAbsent(value, arg_0 -> MapServerTranslator._set_defaultLanguage_$lambda$0(defaultLanguage.1.INSTANCE, arg_0));
        this.defaultLanguage = value;
    }

    @Override
    public synchronized void register(@NotNull String languageName, @NotNull Map<String, String> languageMap) {
        Intrinsics.checkNotNullParameter(languageName, "languageName");
        Intrinsics.checkNotNullParameter(languageMap, "languageMap");
        Map map2 = this.languages.computeIfAbsent(languageName, arg_0 -> MapServerTranslator.register$lambda$1(register.language.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(map2, "computeIfAbsent(...)");
        Map language2 = map2;
        language2.putAll(languageMap);
    }

    @Override
    @NotNull
    public synchronized Map<String, String> getLanguage(@NotNull String languageName) {
        Intrinsics.checkNotNullParameter(languageName, "languageName");
        Map<String, Map<String, String>> map2 = this.languages;
        String string = languageName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String string2 = string;
        Map<String, String> map3 = map2.get(string2);
        if (map3 == null) {
            boolean bl = false;
            String string3 = this.getDefaultLanguage().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            map3 = this.languages.get(string3);
            if (map3 == null) {
                throw new IllegalStateException("Default language doesn't exist");
            }
        }
        return map3;
    }

    private static final Map _set_defaultLanguage_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map register$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Map)$tmp0.invoke(p0);
    }
}

