/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.ResourceLocationUtil;
import su.plo.lib.mod.client.render.TextureUtilKt;
import su.plo.slib.api.entity.player.McGameProfile;

public final class ModPlayerSkins {
    private static final Cache<String, ResourceLocation> skins = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @Nullable String fallback) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(playerId);
        if (playerInfo != null) {
            return;
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return;
        }
        if (fallback != null) {
            ResourceLocation fallbackIdentifier = ResourceLocationUtil.tryBuild("plasmovoice", "skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)nick.toLowerCase()));
            TextureUtilKt.registerBase64Texture(fallback, fallbackIdentifier);
            skins.put((Object)nick, (Object)fallbackIdentifier);
        }
        GameProfile profile = new GameProfile(playerId, nick);
        SkinManager skinManager = Minecraft.m_91087_().m_91109_();
        Map textures = skinManager.m_118815_(profile);
        if (textures.isEmpty()) {
            skinManager.m_118817_(profile, (type, identifier, texture) -> {
                if (type.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                    skins.put((Object)profile.getName(), (Object)identifier);
                }
            }, false);
        } else {
            String hash = Hashing.sha1().hashUnencodedChars((CharSequence)((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getHash()).toString();
            ResourceLocation identifier2 = ResourceLocation.m_135820_((String)("skins/" + hash));
            skins.put((Object)profile.getName(), (Object)identifier2);
        }
    }

    public static synchronized void loadSkin(@NotNull McGameProfile gameProfile) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)gameProfile.getName());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = ModPlayerSkins.getInsecureSkinLocation(profile);
        skins.put((Object)gameProfile.getName(), (Object)skinLocation);
    }

    public static ResourceLocation getInsecureSkinLocation(GameProfile gameProfile) {
        MinecraftProfileTexture minecraftProfileTexture = (MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(gameProfile).get(MinecraftProfileTexture.Type.SKIN);
        return minecraftProfileTexture != null ? Minecraft.m_91087_().m_91109_().m_118825_(minecraftProfileTexture, MinecraftProfileTexture.Type.SKIN) : ModPlayerSkins.getDefaultSkin(gameProfile.getId());
    }

    @NotNull
    public static synchronized ResourceLocation getSkin(@NotNull UUID playerId, @NotNull String nick) {
        PlayerInfo playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(playerId);
        if (playerInfo != null) {
            return playerInfo.m_105337_();
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return skinLocation;
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static ResourceLocation getDefaultSkin(@NotNull UUID playerId) {
        return DefaultPlayerSkin.m_118627_((UUID)playerId);
    }

    private ModPlayerSkins() {
    }
}

