/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.gui.narration.NarrationOutput;
import su.plo.lib.mod.client.gui.widget.GuiNarrationWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.gui.widget.GuiWidgetTexture;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.slib.api.chat.component.McTextComponent;

public abstract class GuiAbstractWidget
implements GuiWidget,
GuiNarrationWidget,
GuiWidgetListener {
    public static int COLOR_WHITE = 0xFFFFFF;
    public static int COLOR_GRAY = 0xA0A0A0;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected McTextComponent text;
    protected float alpha = 1.0f;
    protected boolean hovered;
    protected boolean active = true;
    protected boolean visible = true;
    private boolean focused;

    public static McTextComponent wrapDefaultNarrationMessage(McTextComponent component) {
        return McTextComponent.translatable("gui.narrate.button", component);
    }

    public GuiAbstractWidget(int x, int y, int width, int height) {
        this(x, y, width, height, McTextComponent.empty());
    }

    public GuiAbstractWidget(int x, int y, int width, int height, @NotNull McTextComponent text) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
    }

    @Override
    public void render(@NotNull PoseStack stack, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        this.hovered = this.isHovered(mouseX, mouseY);
        this.renderButton(stack, mouseX, mouseY, delta);
    }

    @Override
    public GuiNarrationWidget.NarrationPriority narrationPriority() {
        if (this.focused) {
            return GuiNarrationWidget.NarrationPriority.FOCUSED;
        }
        return this.hovered ? GuiNarrationWidget.NarrationPriority.HOVERED : GuiNarrationWidget.NarrationPriority.NONE;
    }

    @Override
    public void updateNarration(@NotNull NarrationOutput narrationOutput) {
        this.defaultButtonNarrationText(narrationOutput);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.active && this.visible && this.isValidClickButton(button))) {
            return false;
        }
        if (this.isClicked(mouseX, mouseY)) {
            this.playDownSound();
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isValidClickButton(button)) {
            this.onDrag(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    @Override
    public boolean changeFocus(boolean lookForwards) {
        if (!this.active || !this.visible) {
            return false;
        }
        this.focused = !lookForwards;
        this.onFocusedChanged(lookForwards);
        return lookForwards;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && this.isHovered(mouseX, mouseY);
    }

    public void renderButton(@NotNull PoseStack stack, int mouseX, int mouseY, float delta) {
        GuiWidgetTexture sprite = this.getButtonTexture(this.hovered);
        RenderUtil.bindTexture(0, sprite.getLocation());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.m_69478_();
        RenderUtil.defaultBlendFunc();
        RenderSystem.m_69482_();
        RenderUtil.blitSprite(stack, sprite, this.x, this.y, 0, 0, this.width / 2, this.height);
        RenderUtil.blitSprite(stack, sprite, this.x + this.width / 2, this.y, sprite.getSpriteWidth() - this.width / 2, 0, this.width / 2, this.height);
        this.renderBackground(stack, mouseX, mouseY);
        this.renderText(stack, mouseX, mouseY);
    }

    public void renderToolTip(@NotNull PoseStack stack, int mouseX, int mouseY) {
    }

    public void onClick(double mouseX, double mouseY) {
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    public McTextComponent getText() {
        return this.text;
    }

    public boolean isHoveredOrFocused() {
        return this.hovered || this.focused;
    }

    protected void renderBackground(@NotNull PoseStack stack, int mouseX, int mouseY) {
    }

    protected void renderText(@NotNull PoseStack stack, int mouseX, int mouseY) {
        int textColor = this.active ? COLOR_WHITE : COLOR_GRAY;
        RenderUtil.drawCenteredString(stack, this.getText(), this.x + this.width / 2, this.y + (this.height - 8) / 2, textColor | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    protected void playDownSound() {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)1.0f, (float)0.25f));
    }

    protected void onFocusedChanged(boolean focused) {
    }

    protected void defaultButtonNarrationText(NarrationOutput narrationElementOutput) {
        narrationElementOutput.add(NarrationOutput.Type.TITLE, this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarrationOutput.Type.USAGE, McTextComponent.translatable("narration.button.usage.focused", new Object[0]));
            } else {
                narrationElementOutput.add(NarrationOutput.Type.USAGE, McTextComponent.translatable("narration.button.usage.hovered", new Object[0]));
            }
        }
    }

    protected McTextComponent createNarrationMessage() {
        return GuiAbstractWidget.wrapDefaultNarrationMessage(this.getText());
    }

    @NotNull
    protected GuiWidgetTexture getButtonTexture(boolean hovered) {
        if (!this.active) {
            return GuiWidgetTexture.BUTTON_DISABLED;
        }
        if (hovered) {
            return GuiWidgetTexture.BUTTON_ACTIVE;
        }
        return GuiWidgetTexture.BUTTON_DEFAULT;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    protected boolean isClicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    protected boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setText(McTextComponent text) {
        this.text = text;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }
}

