/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.components.AbstractScreenListener;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.widget.GuiWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.RenderUtil;

public abstract class AbstractScrollbar<P extends GuiScreen>
extends AbstractScreenListener
implements GuiWidget {
    protected final List<Entry> entries = Lists.newArrayList();
    protected final List<EntryPosition> entryPositions = Lists.newArrayList();
    protected final P parent;
    protected final int containerWidth;
    protected final int width;
    protected final int height;
    protected int y0;
    protected int y1;
    protected int scrollHeight;
    protected double scrollTop;
    protected boolean scrolling;
    @Nullable
    protected Entry hoveredEntry;

    public AbstractScrollbar(P parent, int containerWidth, int y0, int y1) {
        this.parent = parent;
        this.containerWidth = containerWidth;
        this.width = ((GuiScreen)parent).getWidth();
        this.height = ((GuiScreen)parent).getHeight();
        this.y0 = y0;
        this.y1 = y1;
    }

    @Override
    public void render(@NotNull PoseStack stack, int mouseX, int mouseY, float delta) {
        this.hoveredEntry = this.isMouseOver(mouseX, mouseY) ? (Entry)this.getEntryAtPosition(mouseX, mouseY).orElse(null) : null;
        int trackX0 = this.getScrollbarPosition();
        int trackX1 = trackX0 + 6;
        this.renderList(stack, this.getContainerX0(), this.y0, mouseX, mouseY, delta);
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trackBottom = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.scrollHeight);
            trackBottom = Mth.m_14045_((int)trackBottom, (int)32, (int)(this.y1 - this.y0 - 8));
            int trackTop = (int)this.scrollTop * (this.y1 - this.y0 - trackBottom) / maxScroll + this.y0;
            if (trackTop < this.y0) {
                trackTop = this.y0;
            }
            RenderUtil.fill(stack, trackX0, this.y0, trackX1, this.y1, -16777216);
            RenderUtil.fill(stack, trackX0, trackTop, trackX1, trackTop + trackBottom, -8355712);
            RenderUtil.fill(stack, trackX0, trackTop, trackX1 - 1, trackTop + trackBottom - 1, -4144960);
        }
    }

    @Override
    public List<? extends GuiWidgetListener> widgets() {
        return this.entries;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        this.setScrollTop(this.scrollTop - delta * (double)((float)this.scrollHeight / (float)this.entries.size()));
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
        Optional<Entry> entry = this.getEntryAtPosition(mouseX, mouseY);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (entry.isPresent() && entry.get().mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(entry.get());
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.y0) {
                this.setScrollTop(0.0);
            } else if (mouseY > (double)this.y1) {
                this.setScrollTop(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int diff = this.y1 - this.y0;
                int scrollStep = Mth.m_14045_((int)((int)((float)(diff * diff) / (float)this.scrollHeight)), (int)32, (int)diff);
                double multiplier = Math.max(1.0, maxScroll / (double)(diff - scrollStep));
                this.setScrollTop(this.scrollTop + deltaY * multiplier);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseY >= (double)this.y0 && mouseY <= (double)this.y1 && mouseX >= 0.0 && mouseX <= (double)this.width;
    }

    public void addEntry(@NotNull Entry entry) {
        this.entries.add(entry);
        EntryPosition lastPosition = this.getLastEntryPosition();
        this.entryPositions.add(new EntryPosition(lastPosition.bottom, lastPosition.bottom + entry.getHeight()));
        this.scrollHeight += entry.getHeight();
    }

    public void clearEntries() {
        this.entries.clear();
        this.entryPositions.clear();
        this.scrollHeight = 0;
    }

    public void onEntryHeightChange() {
        this.scrollHeight = 0;
        this.entryPositions.clear();
        this.entries.forEach(entry -> {
            EntryPosition lastPosition = this.getLastEntryPosition();
            this.entryPositions.add(new EntryPosition(lastPosition.bottom, lastPosition.bottom + entry.getHeight()));
            this.scrollHeight += entry.getHeight();
        });
    }

    public void setScrollTop(double scrollTop) {
        this.scrollTop = Mth.m_14008_((double)scrollTop, (double)0.0, (double)this.getMaxScroll());
    }

    protected void renderList(@NotNull PoseStack stack, int x, int y, int mouseX, int mouseY, float delta) {
        RenderUtil.enableScissor(0, 0, this.width, this.y1 - this.y0 + 4);
        for (int index = 0; index < this.entries.size(); ++index) {
            Entry entry = this.entries.get(index);
            EntryPosition position = this.entryPositions.get(index);
            int entryTop = y - (int)this.scrollTop + position.top;
            int entryBottom = y - (int)this.scrollTop + position.bottom;
            if (entryTop > this.y1 || entryBottom < this.y0) continue;
            entry.render(stack, index, x, entryTop, this.containerWidth, mouseX, mouseY, Objects.equals(this.hoveredEntry, entry), delta);
        }
        RenderUtil.disableScissor();
    }

    protected int getContainerX0() {
        return (this.width - this.containerWidth) / 2;
    }

    protected int getContainerX1() {
        return this.getContainerX0() + this.containerWidth;
    }

    protected int getScrollbarPosition() {
        return this.getContainerX1() + 13;
    }

    protected Optional<Entry> getEntryAtPosition(double mouseX, double mouseY) {
        if (mouseX < (double)this.getContainerX0() || mouseX > (double)this.getContainerX1()) {
            return Optional.empty();
        }
        double relativeY = mouseY - (double)this.y0 + this.scrollTop;
        if (relativeY < 0.0 || relativeY > (double)this.scrollHeight) {
            return Optional.empty();
        }
        for (int index = 0; index < this.entries.size(); ++index) {
            EntryPosition position = this.entryPositions.get(index);
            if (!(relativeY > (double)position.top) || !(relativeY <= (double)position.bottom)) continue;
            return Optional.of(this.entries.get(index));
        }
        return Optional.empty();
    }

    private int getMaxScroll() {
        return Math.max(0, this.scrollHeight - (this.y1 - this.y0));
    }

    @NotNull
    private EntryPosition getLastEntryPosition() {
        if (this.entryPositions.size() == 0) {
            return EntryPosition.EMPTY;
        }
        return this.entryPositions.get(this.entryPositions.size() - 1);
    }

    public abstract void init();

    public int getContainerWidth() {
        return this.containerWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public abstract class Entry
    extends AbstractScreenListener {
        protected int height;

        public Entry(int height) {
            this.height = height;
        }

        public void setHeight(int height) {
            if (this.height != height) {
                this.height = height;
                AbstractScrollbar.this.onEntryHeightChange();
            }
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return Collections.emptyList();
        }

        public abstract void render(@NotNull PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public int getHeight() {
            return this.height;
        }
    }

    static class EntryPosition {
        static EntryPosition EMPTY = new EntryPosition(0, 0);
        private int top;
        private int bottom;

        public EntryPosition(int top, int bottom) {
            this.top = top;
            this.bottom = bottom;
        }

        public String toString() {
            return "AbstractScrollbar.EntryPosition(top=" + this.top + ", bottom=" + this.bottom + ")";
        }
    }
}

