/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.entity;

import dev.itsmeow.whisperwoods.entity.EntityAnimalWithTypes;
import dev.itsmeow.whisperwoods.entity.EntityAnimalWithTypesAndSizeContainable;
import dev.itsmeow.whisperwoods.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.whisperwoods.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.whisperwoods.imdlib.item.ItemModEntityContainer;
import dev.itsmeow.whisperwoods.init.ModEntities;
import dev.itsmeow.whisperwoods.init.ModTags;
import dev.itsmeow.whisperwoods.util.ModPlatformEvents;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityMoth
extends EntityAnimalWithTypesAndSizeContainable {
    private static final EntityDataAccessor<Integer> LANDED = SynchedEntityData.m_135353_(EntityMoth.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TargetingConditions playerPredicate = TargetingConditions.m_148353_().m_26883_(4.0).m_148355_();
    private BlockPos targetPosition;

    public EntityMoth(EntityType<? extends EntityAnimalWithTypesAndSizeContainable> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LANDED, (Object)1);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public boolean isLanded() {
        return (Integer)this.f_19804_.m_135370_(LANDED) != 1;
    }

    public int getLandedInteger() {
        return (Integer)this.f_19804_.m_135370_(LANDED);
    }

    public void setLanded(Direction direction) {
        if (direction == Direction.UP) {
            throw new RuntimeException("Invalid landing direction!");
        }
        this.f_19804_.m_135381_(LANDED, (Object)direction.ordinal());
    }

    public void setNotLanded() {
        this.f_19804_.m_135381_(LANDED, (Object)1);
        this.m_6021_((double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isLanded()) {
            this.m_20256_(Vec3.f_82478_);
            if (Direction.m_122376_((int)this.getLandedInteger()) != Direction.DOWN) {
                double x = Math.floor(this.m_20185_()) + 0.5;
                double z = Math.floor(this.m_20189_()) + 0.5;
                BlockPos pos = new BlockPos(x, Math.floor(this.m_20186_()) + 0.5, z);
                BlockPos offset = pos.m_121945_(Direction.m_122376_((int)this.getLandedInteger()));
                BlockPos diff = pos.m_121996_((Vec3i)offset);
                this.m_6021_(x - (double)diff.m_123341_() / 2.778, Math.floor(this.m_20186_()) + 0.5, z - (double)diff.m_123343_() / 2.778);
                this.m_146922_(0.0f);
                this.f_20885_ = 0.0f;
            } else {
                this.m_6021_(this.m_20185_(), Math.floor(this.m_20186_()), this.m_20189_());
            }
        } else {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    protected void m_8024_() {
        int moths_req;
        super.m_8024_();
        BlockPos blockpos = this.m_20183_();
        if (this.isLanded()) {
            Direction d = Direction.m_122376_((int)this.getLandedInteger());
            BlockPos offset = blockpos.m_121945_(d);
            if (this.f_19853_.m_8055_(offset).m_60659_((BlockGetter)this.f_19853_, offset, d.m_122424_(), SupportType.CENTER)) {
                if (this.f_19853_.m_45946_(playerPredicate, (LivingEntity)this) != null || this.m_217043_().m_188503_(this.isAttractedToLight() ? 500 : 1000) == 0) {
                    this.setNotLanded();
                }
            } else {
                this.setNotLanded();
            }
        }
        if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_123314_((Vec3i)this.m_20183_(), 1.0) && !EntityMoth.isLightBlock(this.f_19853_.m_8055_(this.targetPosition))) {
            int i = 12;
            int j = 2;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos destinationBlock = null;
            if (this.isAttractedToLight()) {
                int k = 0;
                while (k <= j) {
                    for (int l = 0; l < i; ++l) {
                        int i1 = 0;
                        while (i1 <= l) {
                            int j1;
                            int n = j1 = i1 < l && i1 > -l ? l : 0;
                            while (j1 <= l) {
                                blockpos$mutableblockpos.m_122190_((Vec3i)this.m_20183_()).m_122184_(i1, k - 1, j1);
                                BlockState state = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                                if (EntityMoth.isLightBlock(state) && (destinationBlock == null || state.m_60791_() >= this.f_19853_.m_8055_(destinationBlock).m_60791_())) {
                                    destinationBlock = blockpos$mutableblockpos.m_7949_();
                                }
                                j1 = j1 > 0 ? -j1 : 1 - j1;
                            }
                            i1 = i1 > 0 ? -i1 : 1 - i1;
                        }
                    }
                    k = k > 0 ? -k : 1 - k;
                }
            }
            if (destinationBlock != null) {
                this.targetPosition = destinationBlock;
                this.setNotLanded();
            } else {
                boolean found = false;
                if (this.isAttractedToLight()) {
                    for (LivingEntity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(10.0))) {
                        for (InteractionHand hand : InteractionHand.values()) {
                            ItemStack held = entity.m_21120_(hand);
                            if (!held.m_204117_(ModTags.Items.MOTH_TARGET_HELD_LIGHT_ITEMS)) continue;
                            this.targetPosition = entity.m_20183_().m_7637_(0.0, 1.5, 0.0);
                            found = true;
                            this.setNotLanded();
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                }
                if (!found && this.f_19853_.m_45946_(playerPredicate, (LivingEntity)this) == null && this.m_217043_().m_188503_(this.isAttractedToLight() ? 80 : 30) == 0) {
                    for (Direction direction : Direction.values()) {
                        BlockPos offset;
                        if (direction == Direction.UP || !this.f_19853_.m_8055_(offset = blockpos.m_121945_(direction)).m_60659_((BlockGetter)this.f_19853_, offset, direction.m_122424_(), SupportType.CENTER)) continue;
                        this.setLanded(direction);
                        this.targetPosition = null;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.targetPosition = new BlockPos(this.m_20185_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5), this.m_20186_() + (double)this.f_19796_.m_188503_(4) - 1.0, this.m_20189_() + (double)this.f_19796_.m_188503_(5) - (double)this.f_19796_.m_188503_(5));
                }
            }
        }
        if (!this.isLanded() && this.targetPosition != null) {
            if (this.m_5830_()) {
                this.targetPosition = this.tryToFindPositionSlow(pos -> {
                    AABB abb = this.m_20191_();
                    Vec3 diff = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5).m_82546_(this.m_20182_());
                    double length = diff.m_82553_();
                    diff = diff.m_82541_();
                    int i = 1;
                    while ((double)i < length) {
                        if (!this.f_19853_.m_45756_((Entity)this, abb = abb.m_82383_(diff))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                });
            }
            double d0 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
            double d1 = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
            double d2 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
            Vec3 vec3d = this.m_20184_();
            Vec3 vec3d1 = vec3d.m_82520_((Math.signum(d0) * 0.5 - vec3d.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.f_82481_) * (double)0.1f);
            this.m_20256_(vec3d1);
            float f = (float)(Mth.m_14136_((double)vec3d1.f_82481_, (double)vec3d1.f_82479_) * 57.2957763671875) - 90.0f;
            float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
            this.f_20902_ = 0.5f;
            this.m_146922_(this.m_146908_() + f1);
        }
        if ((moths_req = this.getContainer().getCustomConfiguration().getInt("moths_to_destroy_torch")) != 0 && this.f_19853_.m_45976_(EntityMoth.class, this.m_20191_()).size() >= moths_req && this.f_19853_.m_8055_(this.m_20183_()).m_204336_(ModTags.Blocks.MOTH_BREAKABLE) && ModPlatformEvents.mobGrief(this.f_19853_, (Mob)this)) {
            BlockState state = this.f_19853_.m_8055_(this.m_20183_());
            Block.m_49950_((BlockState)state, (Level)this.f_19853_, (BlockPos)this.m_20183_());
            this.f_19853_.m_46597_(this.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    private BlockPos tryToFindPositionSlow(Predicate<BlockPos> condition) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int i = 12;
        int j = 2;
        boolean down = false;
        while (!down) {
            int k;
            int n = k = down ? -1 : 0;
            while (down ? k >= -j : k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n2 = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            pos.m_122190_((Vec3i)this.m_20183_()).m_122184_(i1, k, j1);
                            if (condition.test(pos.m_7949_())) {
                                return pos.m_7949_();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k += down ? -1 : 1;
            }
            down = true;
        }
        return null;
    }

    public boolean isAttractedToLight() {
        long time = this.f_19853_.m_46468_() % 24000L;
        return this.f_19853_.m_45517_(LightLayer.SKY, this.m_20183_()) < 10 || time >= 13000L && time <= 23000L;
    }

    private static boolean isLightBlock(BlockState blockState) {
        return blockState.m_60791_() > 0;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.isLanded()) {
            this.setNotLanded();
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LANDED, (Object)compound.m_128451_("Landed"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Landed", ((Integer)this.f_19804_.m_135370_(LANDED)).intValue());
    }

    @Override
    protected float getRandomizedSize() {
        return ((float)this.f_19796_.m_188503_(30) + 1.0f) / 100.0f + 0.15f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    @Override
    public EntityTypeContainer<EntityMoth> getContainer() {
        return ModEntities.MOTH;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return null;
    }

    public EntityTypeContainerContainable<EntityMoth, ItemModEntityContainer<EntityMoth>> getContainableContainer() {
        return ModEntities.MOTH;
    }

    public static void bottleTooltip(EntityTypeContainer<? extends Mob> container, ItemStack stack, Level worldIn, List<Component> tooltip) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("SizeTag")) {
            tooltip.add((Component)Component.m_237113_((String)("Size: " + tag.m_128457_("SizeTag"))).m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})));
        }
    }
}

