/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.world;

import com.izofar.takesapillage.TakesAPillageMod;
import com.izofar.takesapillage.util.MobWeightedEntry;
import com.izofar.takesapillage.util.ModLists;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PillageSiege
implements CustomSpawner {
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int pillagersToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    public int m_7995_(ServerLevel serverlevel, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!serverlevel.m_46461_() && spawnEnemies) {
            float f = serverlevel.m_46942_(0.0f);
            if ((double)f == 0.5) {
                State state = this.siegeState = serverlevel.f_46441_.m_188503_(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
            }
            if (this.siegeState == State.SIEGE_DONE) {
                return 0;
            }
            if (!this.hasSetupSiege) {
                if (!this.tryToSetupSiege(serverlevel)) {
                    return 0;
                }
                this.hasSetupSiege = true;
            }
            if (this.nextSpawnTime > 0) {
                --this.nextSpawnTime;
                return 0;
            }
            this.nextSpawnTime = 2;
            if (this.pillagersToSpawn > 0) {
                this.trySpawn(serverlevel);
                --this.pillagersToSpawn;
            } else {
                this.siegeState = State.SIEGE_DONE;
            }
            return 1;
        }
        this.siegeState = State.SIEGE_DONE;
        this.hasSetupSiege = false;
        return 0;
    }

    private boolean tryToSetupSiege(ServerLevel serverLevel) {
        for (Player player : serverLevel.m_6907_()) {
            BlockPos blockpos;
            if (player.m_5833_() || !serverLevel.m_8802_(blockpos = player.m_20183_()) || serverLevel.m_204166_(blockpos).m_203656_(BiomeTags.f_215805_)) continue;
            for (int i = 0; i < 10; ++i) {
                float f = serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
                this.spawnX = blockpos.m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)f) * 32.0f));
                this.spawnY = blockpos.m_123342_();
                this.spawnZ = blockpos.m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)f) * 32.0f));
                Vec3 siegeLocation = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
                if (siegeLocation == null) continue;
                this.nextSpawnTime = 0;
                this.pillagersToSpawn = serverLevel.f_46441_.m_188503_(6) + 4;
                break;
            }
            if ((double)serverLevel.m_46942_((float)serverLevel.m_8044_()) > Mth.m_14185_((double)0.4583333333333333)) {
                serverLevel.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_12355_, SoundSource.NEUTRAL, 64.0f, 1.0f);
                serverLevel.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
                serverLevel.m_142346_(null, GameEvent.f_157792_, blockpos);
            }
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel serverLevel) {
        Vec3 vec3 = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3 != null) {
            AbstractIllager pillager;
            try {
                pillager = (AbstractIllager)((EntityType)((MobWeightedEntry)ModLists.get_pillager_siege_list().m_216829_(serverLevel.f_46441_).get()).getData()).m_20615_((Level)serverLevel);
                pillager.m_21530_();
                if (serverLevel.f_46441_.m_188503_(6) < 1) {
                    pillager.m_8061_(EquipmentSlot.HEAD, Raid.m_37779_());
                    pillager.m_21409_(EquipmentSlot.HEAD, 2.0f);
                }
                pillager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(pillager.m_20183_()), MobSpawnType.EVENT, null, null);
            }
            catch (Exception exception) {
                TakesAPillageMod.LOGGER.warn("Failed to create pillager for pillage siege at {}", (Object)vec3, (Object)exception);
                return;
            }
            pillager.m_7678_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, serverLevel.f_46441_.m_188501_() * 360.0f, 0.0f);
            serverLevel.m_47205_((Entity)pillager);
        }
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel serverLevel, BlockPos blockPos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = blockPos.m_123341_() + serverLevel.f_46441_.m_188503_(16) - 8;
            BlockPos blockpos = new BlockPos(j, l = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = blockPos.m_123343_() + serverLevel.f_46441_.m_188503_(16) - 8), k);
            if (!serverLevel.m_8802_(blockpos) || !Monster.m_219013_((EntityType)EntityType.f_20513_, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.EVENT, (BlockPos)blockpos, (RandomSource)serverLevel.f_46441_)) continue;
            return Vec3.m_82539_((Vec3i)blockpos);
        }
        return null;
    }

    static enum State {
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

